/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	"memory_debug.h"
#include	"lc_encode.h"

typedef struct extucs4_work {
	unsigned int	buf[4];
	char		len;
} EXTUCS4_WORK;

void * open_extucs4();
int close_extucs4(unsigned char *,void *);
int extucs42int(L_CHAR *,void*,unsigned char);
int int2extucs4(unsigned char *,void*,L_CHAR);

static LCZ_SET main_code[] = {
	{0,LCZM_4B_TYPE},
	{LCC_ERROR,0}
};


CODE_METHOD extucs4_cm = {
	"EXTUCS-4",
	LCC_EXTUCS4,
	main_code,
	8,
	0,
	{0,0},
	open_extucs4,
	close_extucs4,
	extucs42int,
	int2extucs4,
	0
};


void *
open_extucs4()
{
EXTUCS4_WORK * ret;
int i;
	ret = d_alloc(sizeof(EXTUCS4_WORK));
	ret->len = 0;
	for ( i = 0 ; i < 4 ; i ++ ) {
		ret->buf[i] = 0;
	}
	return ret;
}

int
close_extucs4(unsigned char * ret,void * work)
{
	d_f_ree(work);
	return 0;
}

int
extucs42int(L_CHAR * ret,void * w,unsigned char chr)
{
EXTUCS4_WORK * _w;
L_CHAR ch;
	_w = w;
	_w->buf[(int)(_w->len++)] = ((unsigned int)chr)&0x0ff;
	if ( _w->len == 4 ) {
		ch = (_w->buf[0]<<24)|
			(_w->buf[1]<<16)|
			(_w->buf[2]<<8)|
			_w->buf[3];
		*ret = ch;
		_w->len = 0;
		return 1;
	}
	return 0;
}

int
int2extucs4(unsigned char * ret,void * _work,L_CHAR ch)
{
	ret[0] = (ch>>24)&0x0ff;
	ret[1] = (ch>>16)&0x0ff;
	ret[2] = (ch>>8)&0x0ff;
	ret[3] = ch&0x0ff;
	return 4;
}
