/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "vpf_std.h"
#include "vpf_file.h"
#include "gm_water_course_lft.h"

void gm_water_course_lft_delete(GM_WATER_COURSE_LFT_RECORD *record){
	if(record->nam)
		free(record->nam);
	free(record);
}

VPF_RECORD_READER_BEGIN(
	gm_water_course_lft_read, 
	GM_WATER_COURSE_LFT_RECORD)

	VPF_READ_FIELD(id)
	VPF_READ_FIELD(f_code);
	VPF_READ_FIELD(hyc);
	VPF_READ_VARIABLE_TEXT_FIELD(nam);
	VPF_READ_FIELD(soc);
	VPF_READ_FIELD(tile_id);
	VPF_READ_FIELD(edg_id);
VPF_RECORD_READER_END()

LONG gm_water_course_lft_get_tileid(const GM_WATER_COURSE_LFT_RECORD *record)
{
	return record->tile_id;
}

LONG gm_water_course_lft_get_edge_id(const GM_WATER_COURSE_LFT_RECORD *record)
{
	return record->edg_id;	
}

void gm_water_course_lft_write_information_tag(FILE *fp, const GM_WATER_COURSE_LFT_RECORD *record)
{
	fprintf(fp, 
		"<WaterCourse>\n"
		"<FACCFeatureCode>%s</FACCFeatureCode>\n"
		"<HydrologicalCategory>%hi</HydrologicalCategory>\n"
		"<Name>%s</Name>\n"
		"</WaterCourse>\n",
		record->f_code, 
		record->hyc,
		record->nam);
}
