/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef __KIBANDATA_UTIL_H__
#define __KIBANDATA_UTIL_H__

#include <stdio.h>
#include <stdlib.h>

#ifdef WIN32
#define PATH_DEVIDER '\\'
#else
#define PATH_DEVIDER '/'
#endif

#ifndef MAX_PATH
#define MAX_PATH 260
#endif

typedef struct v_list {
	struct v_list *pNext;
	struct v_list *pPrev;
	void *Data;
} V_LIST;

V_LIST *vl_Front(V_LIST *);
V_LIST *vl_Back(V_LIST *);
V_LIST *vl_PushBack(V_LIST *,void *);
V_LIST *vl_PushFront(V_LIST *,void *);
#define VL_FREEDATA 1
void vl_Free(V_LIST *, int Flags);


typedef struct v_tree {
	struct v_tree *pLeft;
	struct v_tree *pRight;
	int nKey;
	void *Value;
}V_TREE;
void *v_Find(V_TREE *p, int nKey);
V_TREE *v_Add(V_TREE *p, int nKey, void *Value);
void v_Free(V_TREE *p);


typedef struct vc_tree {
	struct vc_tree *pLeft;
	struct vc_tree *pRight;
	char *Key;
	void *Value;
}VC_TREE;
void *vc_Find(VC_TREE *p, char *Key);

#define VCA_COPYKEY    1
VC_TREE *vc_Add(VC_TREE **pp, char *Key, void *Value, int Flags);
#define VCF_FREEKEY    1
#define VCF_FREEVALUE  2
void vc_Free(VC_TREE *p, int Flags);


#define VCH_HASH_MAX   1024
typedef struct vc_hash_table{
	struct vc_tree *Table[VCH_HASH_MAX];
}VC_HASH_TABLE;
void *vch_Find(VC_HASH_TABLE *p, char *Key);
void vch_Add(VC_HASH_TABLE *p, char *Key, void *Value, int Flags);
void vch_Free(VC_HASH_TABLE *p, int Flags);
int vch_GetKey(char *Key);

typedef struct pair_tree {
	struct pair_tree *pLeft;
	struct pair_tree *pRight;
	int nKey;
	int nValue;
}PAIR_TREE;

int pt_Find(PAIR_TREE *p, int nKey);
PAIR_TREE *pt_Add(PAIR_TREE *p, int nKey, int nValue);
void pt_Free(PAIR_TREE *p);

void ExtractFileName(const char *szPath, char *szFileName);
void ExtractFilePath(const char *szFullPath, char *szPathName);
void EnumDirNames(const char *szFilePath, int (*EnumDirNameProc)(char *,long), long lParam);
void SetPathDevider(char *szPath);
void MakeDirectory(const char *szPath);

#ifdef _DEBUG
extern FILE *g_fpLog;
#define LOG_OPEN() g_fpLog = fopen("gbs.log","w");
#define LOG_CLOSE() fclose(g_fpLog);
#define LOG_WRITE(msg1, msg2, msg3, param) fprintf(g_fpLog, "%s : %s : %s : %d\n", msg1, msg2, msg3, param);
#else
#define LOG_OPEN()
#define LOG_CLOSE()
#define LOG_WRITE(msg1, msg2, msg3, param)
#endif

void strtoupper(char *str);

// chop '\r' end of str
void chop(char *str);
void er_panic(char * str);

#endif
