// ===========================================================================
//	LException.h				PowerPlant 2.2.1		 1999 Metrowerks Inc.
// ===========================================================================
//
//	PowerPlant Exception class

#ifndef _H_LException
#define _H_LException
#pragma once

#include "PP_Prefix.h"
#include "PP_Types.h"
#include <exception>

#if PP_Uses_Pragma_Import
	#pragma import on
#endif

PP_Begin_Namespace_PowerPlant


// ---------------------------------------------------------------------------

class LException : public PP_STD::exception {
public:
						LException(
								SInt32			inErrorCode,
								ConstStringPtr	inErrorString = nil);

						LException( const LException& inException );

	LException&			operator = ( const LException& inException );

	virtual				~LException() throw();

	virtual const char*	what() const throw();

	SInt32				GetErrorCode() const;

	void				SetErrorCode( SInt32 inErrorCode );

	ConstStringPtr		GetErrorString() const;

	void				SetErrorString( ConstStringPtr inErrorString );

protected:
	SInt32			mErrorCode;
	Str255			mErrorString;

	// -----------------------------------------------------------------------
	//	Class Functions

public:
	static void			Throw(	SInt32			inErr);

	static void			Throw(	SInt32			inErr,
								ConstStringPtr	inErrStr);
};


// ===========================================================================
//	Inline function definitions

// ---------------------------------------------------------------------------
//	 GetErrorCode											 [inline] [public]
// ---------------------------------------------------------------------------

inline SInt32
LException::GetErrorCode() const
{
	return mErrorCode;
}


// ---------------------------------------------------------------------------
//	 GetErrorString										 [inline] [public]
// ---------------------------------------------------------------------------

inline ConstStringPtr
LException::GetErrorString() const
{
	return mErrorString;
}


// ---------------------------------------------------------------------------

PP_End_Namespace_PowerPlant

#if PP_Uses_Pragma_Import
	#pragma import reset
#endif

#endif
