/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB
#define LIBRARY

#include	<stdio.h>
#include	<errno.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<stdlib.h>
#include	<netdb.h>
#include	<fcntl.h>
#include	<signal.h>
#include	<unistd.h>
#include	"task.h"
#include	"utils.h"
#include	"memory_debug.h"
#include	"stream.h"
#include	"netutils.h"
#include	"machine/fork_lock.h"
#include	"machine/err.h"
#include	"pri_level.h"
#include	"chimera.h"

#define CON_TIMEOUT	(4*60)
extern int max_fid,now_open_files;
extern SEM netutils_lock,stream_lock;
extern CHIMERA_SEM task_lock;

typedef struct connect_t {
	struct connect_t *	next;
	unsigned		finish_flag:1;
	int			id;
	struct sockaddr*	server;
	int			len;
	int			ret;
	int			err;
	CHIMERA_HTID		tid;
} CONNECT_T;

typedef struct connect_list {
	struct connect_list *	next;
	int			tid;
	int			fd;
} CONNECT_LIST;

int con_err;
int con_errno;

int do_connect_waiting_cnt;
CONNECT_T * connect_t_head,*connect_t_tail;

void
do_connect_task(TKEY a)
{
CONNECT_T * arg;

	chimera_lock_task(task_lock,__FILE__,__LINE__);
	do_connect_waiting_cnt --;
	for ( ; ; ) {
		for ( ; connect_t_head == 0 ; ) {
			if ( do_connect_waiting_cnt ) {
				chimera_unlock_task(task_lock,"connect",__FILE__,__LINE__);
				return;
			}
			do_connect_waiting_cnt ++;
			chimera_sleep_task((int)&connect_t_head,task_lock,0);
			chimera_lock_task(task_lock,__FILE__,__LINE__);
			do_connect_waiting_cnt --;
		}
		arg = connect_t_head;
		arg->tid = _chimera_get_tid();
		connect_t_head = arg->next;
		if ( connect_t_head == 0 )
			connect_t_tail = 0;
		chimera_unlock_task(task_lock,"connect",__FILE__,__LINE__);
		
		errno = 0;
		arg->ret = connect(arg->id,arg->server,arg->len);
		arg->err = errno;
		arg->finish_flag = 1;
		normal_wakeup_task((int)arg,1);


		chimera_lock_task(task_lock,__FILE__,__LINE__);
	}
}


void
do_connect(CONNECT_T * arg)
{

	arg->finish_flag = 0;
	chimera_lock_task(task_lock,__FILE__,__LINE__);
	if ( do_connect_waiting_cnt == 0 ) {
		chimera_create_task(do_connect_task,0,PRI_FETCH);
		do_connect_waiting_cnt ++;
	}
	arg->next = 0;
	if ( connect_t_head ) {
		connect_t_tail->next = arg;
		connect_t_tail = arg;
	}
	else	connect_t_head = connect_t_tail = arg;
	chimera_wakeup_task((int)&connect_t_head,0);
	chimera_unlock_task(task_lock,"connect",__FILE__,__LINE__);
	for ( ; arg->finish_flag == 0 ; )
		sleep_task((int)arg,SEM_NULL);
}

void
timeout_connect(CONNECT_T * c)
{
	lock_task(stream_lock);
	if ( c->tid.valid )
		pthread_kill((pthread_t)c->tid.tid, SIGUSR1);
	unlock_task(stream_lock,"timeout_connect");
}

STREAM *
new_connection(
	int * cerr,
	char * hostname,
	int ip,
	short port,
	int (*func)(),
	void * work)
{
int id;
struct sockaddr_in server;

struct sockaddr_in client;
int len;
HOST_ENTRY * hp;
STREAM * ret;
extern S_TABLE s_file_table;
int f;
FORK_LOCK_TBL ft;
int con_time;
CONNECT_T c;
WD_ENTRY * ent;
int wd_ret;
CONNECT_LIST cl;

	lock_task(stream_lock);
	if ( shutdown_stream_flags & STT_NET ) {
		unlock_task(stream_lock,"connect");
		return 0;
	}
	unlock_task(stream_lock,"connect");

	if ( func )
		(*func)(0,work);
	if ( hostname ) {
		errno = 0;
		hp = r_gethostbyname(hostname);
		if ( hp == 0 ) {
			fprintf(stderr,"%s e=%i p=%i\n",
				hostname,errno,(int)getpid());
			perror("Error(clinet): can't gethostbyname\n");
			*cerr = errno;
			return 0;
		}
		ip = hp->ips[0].d.v4;

	}
	f = 0;
	con_time = get_xltime();
retry:
	if ( get_xltime() - con_time > CON_TIMEOUT ) {
		con_err = 4;
		*cerr = ESYS_CTIMEOUT;
		goto err2;
	}
	/* TCP 17 */
	errno = 0;

	if ((id = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		if ( f == 0 && errno == EMFILE && stream_gc ) {

			f = 1;
			(*stream_gc)();
			goto retry;
		}
		if ( func )
			(*func)(1,work);

		perror("Error(clinet): can't socket\n");
		*cerr = errno;

		return 0;
	}

	cl.fd = id;
/*
	if ( insert_c_list(&cl) < 0 )
		goto retry_socket;
*/

	client.sin_family = AF_INET;
	client.sin_addr.s_addr = ntohl(INADDR_ANY);
	client.sin_port = 0;
	len = sizeof(client);
	if (bind(id, (struct sockaddr *)&client, len) == -1) {


		fprintf(stderr,"PID = %i\n",(int)getpid());
		perror("Error(clinet): can't bind\n");
		con_err = 3;

		close(id);
		if ( func )
			(*func)(1,work);
		*cerr = errno;

		return 0;
	}

	server.sin_family = AF_INET;
	server.sin_addr.s_addr = htonl(ip);
	server.sin_port = htons(port);
	len = sizeof(server);

con_retry:
	rlock_fork(&ft);
	errno = 0;
	c.id = id;
	c.server = (struct sockaddr*)&server;
	c.len = len;
	c.tid.tid = -1;
	c.tid.valid = 0;

	new_tick((void(*)(int))timeout_connect,-2*CON_TIMEOUT,(int)&c);

	ent = wait_data_lock(id,WDT_CLOSE);

	do_connect(&c);

	lock_task(stream_lock);
	c.id = -1;
	c.tid.tid = -1;
	c.tid.valid = 0;
	unlock_task(stream_lock,"connect");

	wd_ret = wait_data_unlock(ent);

	del_tick_with_data((void(*)(int))timeout_connect,(int)&c);

	if ( c.ret == -1) {
		runlock_fork(&ft);
		if ( ft.err ) {

			if ( wd_ret == 0 )
				close(id);
			goto retry;
		}
		if ( c.err != ECONNREFUSED ) {

			con_errno = c.err;
			if ( get_xltime() - con_time > CON_TIMEOUT ) {


				con_err = 4;
				*cerr = ESYS_CTIMEOUT;
				if ( wd_ret == 0 )
					close(id);
				goto err2;
			}
			if ( wd_ret ) {
				goto retry;
			}
			sleep_sec(1);
			goto con_retry;
		}
		if ( c.err == EISCONN )
			goto ok;
		con_err = 5;

		if ( wd_ret == 0 )
			close(id);
		if ( func )
			(*func)(1,work);
		*cerr = c.err;
		return 0;
	err2:
		if ( func )
			(*func)(1,work);
		return 0;
	}

	runlock_fork(&ft);
	if ( ft.err ) {
		close(id);
		goto retry;
	}
ok:

#ifndef O_RSYNC
	fcntl(id,F_SETFL,O_RDWR|O_FSYNC);
#else
	fcntl(id,F_SETFL,O_RDWR|O_RSYNC);
#endif
	if ( func )
		(*func)(1,work);
	ret = d_alloc(sizeof(S_FILE));
	ret->h.tbl = &s_file_table;
	ret->h.thread = 0;
	ret->file.fid = id;
	ret->file.filename = 0;
	lock_task(stream_lock);
	_s_open(ret,O_RDWR,STT_NET);
	now_open_files ++;
	if ( ret->file.fid < id )
		max_fid = id;
	unlock_task(stream_lock,"new_connection");
	return ret;
}

