/**********************************************************************
 
	Copyright (C) 2003-2007 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"utils.h"
#include	"memory_debug.h"

char *
get_locale()
{
static char * locale_str;
CFLocaleRef userLocaleRef;
char * str;
char * target;
CFDataRef * data;
int len;
int i;
	if ( locale_str )
		return locale_str;
	userLocaleRef = CFLocaleCopyCurrent();
	str = CFDataGetBytePtr(data=
		CFStringCreateExternalRepresentation(
			NULL, CFLocaleGetIdentifier(userLocaleRef),
			kCFStringEncodingUTF8,'?')
	    );
	len = CFDataGetLength(data);
	target = d_alloc(len+1);
	memcpy(target,str,len);
	target[len] = 0;
	
	locale_str = get_abstract_locale(target);
	
	d_f_ree(target);
	
	CFRelease(userLocaleRef);
	CFRelease(data);
	
	return locale_str;
}

