/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VFocusView.h"
#include "machine/v_object.h"

static gboolean
v_focus_view_focus(GtkWidget*wid, GdkEventFocus *event, gpointer user_data)
{
	VFocusView *vobj = (VFocusView*)user_data;
	vobj->focus_event(event->in);
	if ( event->in == true )
		vobj->check_menu_status();
	return FALSE;
}

VInfo *
v_focus_view_create(VFocusView *vobj)
{
	GtkWidget *ev = gtk_event_box_new();
	GTK_WIDGET_SET_FLAGS(ev,GTK_CAN_FOCUS);
	g_signal_connect (GTK_OBJECT (ev), "focus-in-event",
		GTK_SIGNAL_FUNC (v_focus_view_focus), vobj);
	g_signal_connect (GTK_OBJECT (ev), "focus-out-event",
		GTK_SIGNAL_FUNC (v_focus_view_focus), vobj);
	
	GtkWidget *box = gtk_vbox_new(0,0);
	gtk_container_add(GTK_CONTAINER(ev),box);
	gtk_widget_show(box);
	return ev;
}

VExError
VFocusView::create_do(const VObjectStatus* s, int flags,
		VObject * nmp, void * arg)
{
	command_status_handler = 0;
	obey_command_handler = 0;
	menu_dirty = 1;

	info = v_serialized_exec_func(v_focus_view_create, this);
	v_serialized_exec_sub(g_object_ref, info);

	return return_create_do(this,nmp,&sts,s,flags);
}

void
VFocusView::destroy_do(VObject * nmp)
{
	nmp->remove_child_do(this);
	
	v_serialized_exec_sub(gtk_widget_destroy, info);
	v_serialized_exec_sub(g_object_unref, info);
}

VFocusView::~VFocusView()
{
}

VExError
VFocusView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	GtkBox *box = GTK_BOX(GTK_BIN(info)->child);
	
	if ( flags & VSF_HOMOGEN ) {
		s->homogeneous = v_serialized_exec_func(gtk_box_get_homogeneous, box);
		flags &= ~VSF_HOMOGEN;
	}

	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	
	V_OP_END
	return err;
};

VExError
VFocusView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, info);
	err = VObject::set_status(s,flags);
	if ( err.code ) {
		V_OP_END
		return err;
	}
	
	GtkBox *box = GTK_BOX(GTK_BIN(info)->child);
	if ( flags & VSF_HOMOGEN ) {
		v_serialized_exec_sub(gtk_box_set_homogeneous, box, s->homogeneous);
		err.subcode1 &= ~VSF_HOMOGEN;
	}
	if ( flags & VSF_SPACING ) {
		v_serialized_exec_sub(gtk_box_set_spacing, box, s->spacing.h);
		err.subcode1 &= ~VSF_SPACING;
	}
	
	V_OP_END
		
	if ( flags & (VSF_ALIGN | VSF_PADDING ) ) {
		if ( sts.parent )
			sts.parent->child_status_changed(this, info);
		err.subcode1 &= ~(VSF_ALIGN | VSF_PADDING );
	}
	return err;
}

VExError
VFocusView::add_child_do(VObject* child)
{
	VObjectStatus s;
	GtkBox *box = GTK_BOX(GTK_BIN(info)->child);
	VInfo * cinfo = child->get_info_this();
	child->get_status(&s, VSF_ALIGN | VSF_PADDING);
	char align = s.alignv;
	v_serialized_exec_sub(gtk_box_pack_start,
		box, cinfo, 
		align == VALIGN_EXPAND || align == VALIGN_FILL,
		align == VALIGN_FILL, s.padding.h);
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VFocusView::remove_child_do(VObject* child)
{
	GtkContainer *box = GTK_CONTAINER(GTK_BIN(info)->child);
	v_serialized_exec_sub(gtk_container_remove, box,
			child->get_info_this());
}

struct v_children_align_list
{
	VInfo *			info;
	unsigned	align : 2;
	short			padding;
	v_children_align_list *	next;
};

extern void v_align_view_realign_children(VInfo *info, v_children_align_list *list, int n);

void
VFocusView::child_status_changed(VObject *child, VInfo* cinfo)
{
	VObjectStatus s;
	VObject * nmc;
	v_children_align_list *t, *list = 0, *last = 0;
	int m = 0;
	for ( VObjectList *child = sts.children ; 
				child ; child = child->next ) {
		nmc = child->object->get_nmc(0);
		if ( nmc == 0 )
			continue;
		child->object->get_status(&s, VSF_ALIGN | VSF_PADDING);
		t = new v_children_align_list;
		t->info = nmc->get_info_this();
		t->align = s.alignv;
		t->padding = s.padding.h;
		t->next = 0;
		if ( list == 0 )
			list = t;
		if ( last )
			last->next = t;
		last = t;
		m++;
	}
	v_serialized_exec_sub(v_align_view_realign_children, GTK_BIN(info)->child, list, m);
}

void
VFocusView::redraw(VRect *rect) const
{
	// do nothing
}

void
VFocusView::focus()
{
	v_serialized_exec_sub(gtk_widget_grab_focus, info);
}

void
VFocusView::set_menu_dirty(int d)
{
	menu_dirty = d;
/*
	if ( d )
		check_menu_status();
*/
}

V_CALLBACK_D(VFocusView::call_obey_command_handler)
{
	VFocusView *fv = static_cast<VFocusView*>(object);
	fv->obey_command_handler(object, user_arg, sys_arg);
	fv->set_menu_dirty(1);
}
