/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include "lock_level.h"
#include "machine/msequence.h"
#include "machine/gb_windows.h"
#include "task.h"
#include "pri_level.h"
#include "utils.h"


int mseq_flag=0;

SEM mseq_que_lock;
HANDLE user_interface_thread_finished_event;

MS_INFO * ms_info_head[PRI_MAX];
MS_INFO * ms_info_tail[PRI_MAX];
MS_INFO * process_ms;

int user_interface_task_id;

void (*ms_put_call_back)(int (*func)(), void * arg, char str[]) = 0;
extern void (*ms_lock_func)(char *,int);
extern void (*ms_unlock_func)();
extern void (*ms_inheritance_func)();

void init_app_window();

int polling_task_flag;

int ms_lock_cnt;
char * ms_lock_file;
int ms_lock_line;
int ms_lock_tid;


void v_loop2();

void
init_msequence()
{
extern int get_tid();
int i;

	/* The thread who call init_msequence() is main thread */
	user_interface_task_id = get_tid();
	mseq_que_lock = new_lock(LL_MSEQUENCE);
	for ( i = 0; i < PRI_MAX ; i ++ ) {
		ms_info_head[i] = 0;
		ms_info_tail[i] = 0;
	}
	
	ms_lock_func = ms_lock;
	ms_unlock_func = ms_unlock;
	ms_inheritance_func = ms_inheritance;
	mseq_flag = 1;
}

void _ms_lock(char * file,int line)
{
int tid;
int i;
	tid = get_tid();
retry:
	if ( tid != user_interface_task_id ) {
		for ( i = 0 ; i < PRI_MAX ; i ++ ) {
			if ( ms_info_head[i] ) {
				sleep_task((int)&ms_lock_cnt,mseq_que_lock);
				lock_task(mseq_que_lock);
				goto retry;
			}
		}
		if ( process_ms ) {
				sleep_task((int)&ms_lock_cnt,mseq_que_lock);
				lock_task(mseq_que_lock);
				goto retry;
		}
		if ( ms_lock_tid && ms_lock_tid != tid ) {
			sleep_task((int)&ms_lock_cnt,mseq_que_lock);
			lock_task(mseq_que_lock);
			goto retry;
		}
		ms_lock_tid = tid;
		ms_lock_cnt ++;
		ms_lock_file = file;
		ms_lock_line = line;
	}
	else {
		if ( ms_lock_tid == 0 ) 
			ms_lock_tid = tid;
		ms_lock_cnt ++;
		ms_lock_file = file;
		ms_lock_line = line;
	}
}

void
ms_lock(char * file,int line)
{
	lock_task(mseq_que_lock);
	_ms_lock(file,line);
	unlock_task(mseq_que_lock,"ms_lock");
}

void _ms_unlock()
{
int tid;
	tid = get_tid();
	ms_lock_cnt --;
	if ( ms_lock_cnt == 1 ) {
		wakeup_task((int)&ms_lock_cnt);
	}
	else if ( ms_lock_cnt == 0 ) {
		ms_lock_tid = 0;
		wakeup_task((int)&ms_lock_cnt);
	}
}

void
ms_unlock()
{
	lock_task(mseq_que_lock);
	_ms_unlock();
	unlock_task(mseq_que_lock,"ms_unlock");
}

void
ms_inheritance(int i_tid,char * file,int line)
{
int tid;
	tid = get_tid();
//retry:
	lock_task(mseq_que_lock);
/*
	if ( ms_lock_tid == 0 ) {
		_ms_lock(file,line);
	}
	else if ( ms_lock_tid == i_tid ) {
		for ( ; ms_lock_cnt > 1 ; ) {
			sleep_task((int)&ms_lock_cnt,mseq_que_lock);
			goto retry;
		}
		ms_lock_tid = tid;
		ms_lock_file = file;
		ms_lock_line = line;
	}
	else	er_panic("ms_lock_inheritance");
*/
	ms_lock_tid = tid;
	unlock_task(mseq_que_lock,"ms_unlock");
}


int
ms_loop_1()
{
MS_INFO * ms;
int pri;
int cnt = 0;
int tt;
static tid = -1;

	if ( tid == -1 )
		tid = get_tid();
	tt = get_tid();
	if ( tid != tt )
		er_panic("ms_loop_1");

	for ( ; ; ) {
		
		lock_task(mseq_que_lock);
		for ( pri = PRI_MAX-1 ; pri >= 0 ; pri -- )
			if ( ms_info_head[pri] )
				break;
		if ( pri < 0 ) {
			unlock_task(mseq_que_lock, "ms_loop");
			break;
		}
		ms = ms_info_head[pri];
		ms_info_head[pri] = ms->next;
		if ( ms_info_head[pri] == 0 )
			ms_info_tail[pri] = 0;
		process_ms = ms;
			
		unlock_task(mseq_que_lock, "ms_loop");
/*
printf("do1 %s\n",ms->str);
*/
		ms->result = (*ms->func)(ms->arg);

		lock_task(mseq_que_lock);
		wakeup_task((unsigned int)ms);
		wakeup_task((unsigned int)&ms_lock_cnt);
		cnt++;
		process_ms = 0;
		ms->func = 0;
		unlock_task(mseq_que_lock,"ms_loop");

/*
printf("do1 %s end\n",ms->str);
*/
	}
	return cnt;
}

void
ms_loop()
{
	for ( ; ; )
		ms_loop_1();
}


static void
ms_put_func(MS_INFO * ms)
{
int pri;
extern int get_pri(int tid);

	pri = get_pri(0);
	ms->next = 0;
	if ( ms_info_tail[pri] == 0 ) {
		ms_info_tail[pri] = ms_info_head[pri] = ms;
	}
	else {
		ms_info_tail[pri]->next = ms;
		ms_info_tail[pri] = ms;
	}
}


int
ms_do(int (*func)(void *param), void * arg, char str[])
{
MS_INFO ms;

	if ( polling_task_flag )
		return -1;
	if ( mseq_flag == 0 ) {
		printf("????\n");
		exit(1);
	}
	if ( user_interface_task_id == get_tid() )
		return  (*func)(arg);
	ms.func = func;
	ms.arg = arg;
	strcpy(ms.str,str);

	lock_task(mseq_que_lock);
	ms_put_func(&ms);
	if ( ms_put_call_back )
		(*ms_put_call_back)(func,arg,str);

//	PostThreadMessage(get_userinterface_tid(), WM_MSEQUENCE, 0, 0);

	wakeup_task((int)v_loop2);

	for ( ; ms.func ; ) {
		sleep_task((unsigned int)&ms,mseq_que_lock);
		lock_task(mseq_que_lock);
	}
	unlock_task(mseq_que_lock,"ms_do");

	return ms.result;
}


int get_userinterface_tid()
{
	return user_interface_task_id;
}


void
v_loop2()
{
int pri;
	for ( ; ; ) {
		lock_task(mseq_que_lock);
		for ( pri = PRI_MAX-1 ; pri >= 0 ; pri -- )
			if ( ms_info_head[pri] )
				break;
		if ( pri < 0 ) {
			if ( polling_task_flag ) {
				unlock_task(mseq_que_lock,"v_loop2");
				break;
			}
			sleep_task((int)v_loop2,mseq_que_lock);
			continue;
		}
		unlock_task(mseq_que_lock,"v_loop2");
		ms_loop_1();
	}
}