/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"utils.h"
#include	"lc_encode.h"
#include	"machine/v_types.h"
#include	"machine/lc_util.h"

typedef struct _v_get_font_s {
	LC_FONT * 	f;
	LC_FONT_ENGINE * fe;
	int		ret;
	int is_font_found;
} _V_GET_FONT_S;

static void set_lcz_and_mask_from_codepages(L_CHAR *lcz, L_CHAR *mask, DWORD codepages)
{
	lcz[0]=0;
	mask[0]=0;
	lcz[1] = LCZM_ALL;
	mask[1] = LCC_ERROR;

	if(codepages & 1){
		lcz[0] = LCZ_1BC_WIN1252;
		mask[0] = LCZM_1BYTE;
	}
	if(codepages & (1 << 1)){
		lcz[0] = LCZ_1BC_WIN1250;
		mask[0] = LCZM_1BYTE;
	}
	if(codepages & (1 << 2)){
		lcz[0] = LCZ_1BC_WIN1251;
		mask[0] = LCZM_1BYTE;
	}
	if(codepages & (1 << 17)){
		if(lcz[0]){
			lcz[1] = LCZ_2BC_WIN932;
			mask[1] = LCZM_2BYTE;
		}
		else{
			lcz[1] = LCZ_2BC_WIN932;
			mask[1] = LCZM_2BYTE;
		}
	}
}

static int CALLBACK listup_fount_callback(
	ENUMLOGFONTEXW *lpelfe,
	NEWTEXTMETRICEXW *lpntme,
	DWORD FontType,
	LPARAM lParam
)
{
	LC_FONT_SIZE_LIST sl;
	_V_GET_FONT_S *v;
	LC_FONT *font;
	LC_FONT_ENGINE *fe;
	VFONT *vf;
	
	v = (_V_GET_FONT_S *)lParam;
	font = v->f;
	fe = v->fe;
	
	memset(&sl, 0, sizeof(sl));
	sl.size = -1;
	sl.from = lpntme->ntmTm.tmFirstChar;
	sl.to = lpntme->ntmTm.tmLastChar;
	_insert_lc_font_size_list(font,&sl);
	
	set_lcz_and_mask_from_codepages(font->lcz, font->mask, lpntme->ntmFontSig.fsCsb[0]);

	vf = d_alloc(sizeof(*vf));
	memcpy(vf, &lpelfe->elfLogFont, sizeof(LOGFONTW));
	insert_font_work(font, fe, vf);
	v->is_font_found = TRUE;
	return 0;
}


int
_v_get_font(
	_V_GET_FONT_S * v)
{

LC_FONT * f;
LC_FONT_ENGINE * fe;
HDC hdc;
LOGFONTW logfont;


	f= v->f;
	fe = v->fe;
	
	hdc = GetDC(0);
	memset(&logfont, 0, sizeof(logfont));
	logfont.lfCharSet = DEFAULT_CHARSET;
	l2w_(logfont.lfFaceName, sizeof(logfont.lfFaceName)/sizeof(wchar_t), f->fontname);
	
	v->is_font_found = FALSE;
	EnumFontFamiliesExW(hdc, &logfont, listup_fount_callback, (LPARAM)v, 0);
	ReleaseDC(0,hdc);
	
	if(v->is_font_found){
		v->ret = 0;
	}
	else{
		v->ret = -1;
	}

	return 0;
	
}


int 
v_get_font(LC_FONT * f,LC_FONT_ENGINE * fe)
{
_V_GET_FONT_S v;
	v.f = f;
	v.fe = fe;

	ms_do((int (*)(void *))_v_get_font,(void*)&v,"v_get_font");
	
	return v.ret;
}

VFONT *get_win_gui_vfont()
{
	HFONT gui_font;
	static VFONT gui_vfont;
	static VFONT *ret;
	if(!ret){
		memset(&gui_vfont, 0, sizeof(gui_vfont));
		gui_font = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
		GetObject(gui_font, sizeof(LOGFONT), &gui_vfont);
		ret = &gui_vfont;
	}
	return ret;
}
