/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VSlider.h"
#include "VApplication.h"
#include "vobject_main.h"
#include "vwin_control.h"

class OnHScroll :  public MessageHandler {
	OnCommandFunc func;
	void on_event(VObject *arg,MSG *msg){
		//if ( LOWORD(msg->wParam) == SB_THUMBTRACK )
		//	return;
		VSlider *slider = dynamic_cast<VSlider*>(arg);
		int step = SendMessage((HWND)msg->lParam, TBM_GETLINESIZE, 0, 0);
		int min = SendMessage((HWND)msg->lParam, TBM_GETRANGEMIN, 0, 0);
		int cur = SendMessage((HWND)msg->lParam, TBM_GETPOS, 0, 0);
		int n = ((cur - min + step/2)/step)*step + min;
		if ( n != cur )
			SendMessage((HWND)msg->lParam, TBM_SETPOS, 0, n);
		slider->value_changed();
	}
public:
	OnHScroll(OnCommandFunc f=0):MessageHandler(WM_HSCROLL),func(f){}
};

static HWND CreateTrackBarWindow(
		int style, HWND hwnd, int id,
		int min, int max, int step){
	HWND ret = ::CreateWindowEx(
		0, 
		TRACKBAR_CLASS,
		"",
		style,
		0,
		0,
		0,
		0,
		hwnd,
		(HMENU)id,
		theApp->get_instance(),
		NULL);
	int n = (max-min)/step;
	SendMessage(ret, TBM_SETRANGEMIN, 0, min);
	SendMessage(ret, TBM_SETRANGEMAX, 0, max);
	SendMessage(ret, TBM_SETLINESIZE, 0, step);
	SendMessage(ret, TBM_SETTICFREQ, (max-min)/(n>15?10:n), 0);
	return ret;
}

VExError 
VSlider::create_do(const VObjectStatus* s, int flags, VObject *parent, void * arg)
{
	min = ((range_set*)arg)->min;
	max = ((range_set*)arg)->max;
	step = ((range_set*)arg)->step;

	DWORD style=WS_CHILD | TBS_AUTOTICKS | WS_TABSTOP;
	if(!s->enabled){
		style |= WS_DISABLED;
	}
	if(s->visible){
		style |= WS_VISIBLE;
	}
	
	/* find container window that will own this button.*/
	VContainerInfo *container_info = VInfo::get_container_info(parent);
	int id = container_info->get_next_control_id();
	HWND hwnd = v_serialized_exec_func(CreateTrackBarWindow,
		style, container_info->get_hwnd(), id, min, max, step);
	info = new VInfo(this, hwnd, id);
	
	sts.min_size.w = 100;
	sts.min_size.h = 32;

	info->add_message_handler(new OnHScroll(::value_changed));
	return parent->add_child_do(this);
}

void
VSlider::destroy_do(VObject *parent)
{
	parent->remove_child_do(this);
	if(info){
		v_serialized_exec_sub(::DestroyWindow, info->get_hwnd());
		delete info;
		info = NULL;
	}
	sts.parent->redraw();
}

VSlider::~VSlider()
{
}

VExError
VSlider::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX

	if ( flags & VSF_VALUE ) {
		s->value = v_serialized_exec_func(_SendMessage,
			info->get_hwnd(), TBM_GETPOS, 0, 0);
		flags &= ~VSF_VALUE;
	}
	
	VExError err = VObject::get_status(s,flags);
	win_control_default_get_status(info->get_hwnd(), s, flags, &err);
	V_OP_END
	return err;
};

VExError
VSlider::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = VObject::set_status(s,flags);
	HWND hwnd = info->get_hwnd();
	win_control_default_set_status(hwnd, s, flags&~VSF_DESC, &err);
	
	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(SendMessage, hwnd, TBM_SETPOS, 1, s->value);
		err.subcode1 &= ~VSF_VALUE;
	}

	if ( flags & VSF_CALC_MIN ) {
		// min is set on create
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	
	if ( flags & VSF_VISIBLE ) {
		if ( s->visible != (::IsWindowVisible(info->get_hwnd())==TRUE) ){
			v_serialized_exec_sub(::ShowWindow, hwnd, s->visible ? SW_SHOW : SW_HIDE);
		}
		err.subcode1 &= ~VSF_VISIBLE;
	}

	V_OP_END
	
	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_DESC | VSF_VERTD | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

void
VSlider::redraw(VRect *rect) const
{
	if ( ! info )
		return;
	_V_OP_START_VOID
	win_redraw(info->get_hwnd(), rect);
	V_OP_END
}
