/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>

#include "v/VLayout.h"
#include "VApplication.h"

extern HWND get_active_dialog();
extern int translate_accel(MSG *msg);

bool doing_layout = false;
DWORD current_time;

extern "C" {

#include "machine/gb_windows.h"
#include "machine/msequence.h"
#include "pri_level.h"
#include "xl.h"
#include "task.h"

extern "C" int ms_loop_1();
extern "C" void v_loop2();
extern int polling_task_flag;
int v_loop_tid = 0;

int get_v_loop_tid()
{
	return v_loop_tid;
}


V_CALLBACK_D(do_layout)
{
	VLayout::layout_marked_window();
	doing_layout = false;
}

bool idle_task()
{
	static DWORD last_ms_loop=0;
	static DWORD last_layout=0;
	
	DWORD now = GetTickCount();
	
/*
if(last_ms_loop==0 || now > last_ms_loop + 100)
	{
		ms_loop_1();
		last_ms_loop = now;
	}
*/

	if(last_layout==0 || now > last_layout + 3000)
	{
		if ( ! doing_layout && VLayout::need_layout() ) {
			doing_layout = true;
			vq_insert_callback(NULL,do_layout,0,0,0,0);
		}
		last_layout = now;
	}

	return false;
}

void new_v_loop()
{
	v_loop_tid = get_tid();
	
	MSG msg;
	while(TRUE){
		bool is_message_exists = (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) != 0);
		current_time = msg.time;

		if(is_message_exists){
			if(msg.message == WM_MSEQUENCE){
				ms_loop_1();
			}
			if(msg.message == WM_QUIT) {
				break;
			}
			ms_lock(__FILE__,__LINE__);
			if(msg.message >= WM_MOUSEFIRST && msg.message <= WM_MOUSELAST)
				VTrackedInfo::track_mouse(&msg);
			if ( translate_accel(&msg) ) {
				ms_unlock();
				continue;
			}
			HWND dlg = get_active_dialog();
			if ( dlg && IsDialogMessage(dlg, &msg) ) {
				ms_unlock();
				continue;
			}
			TranslateMessage(&msg);
			DispatchMessage(&msg);

			ms_unlock();
			
		}
		else{
			ms_lock(__FILE__,__LINE__);

			idle_task();
			
			ms_unlock();
			
			Sleep(1);

		}
	}
}

/*
void v_loop(){
	new_v_loop();
}
*/

int
_polling_task(void *d)
{
	v_loop_tid = get_tid();
	
	MSG msg;
	bool is_message_exists = (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) != 0);
	current_time = msg.time;

	if(is_message_exists){
		if(msg.message == WM_QUIT) {
			return -1;
		}
		ms_lock(__FILE__,__LINE__);
		if(msg.message >= WM_MOUSEFIRST && msg.message <= WM_MOUSELAST)
			VTrackedInfo::track_mouse(&msg);
		if ( translate_accel(&msg) ) {
			ms_unlock();
			return 0;
		}
		HWND dlg = get_active_dialog();
		if ( dlg && IsDialogMessage(dlg, &msg) ) {
			ms_unlock();
			return 0;
		}
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		ms_unlock();
			
	}
	return 0;
}


void
polling_task(TKEY d);

void
polling_task(TKEY d)
{
	for ( ; ; ) {
		Sleep(1);
		idle_task();
		if ( ms_do(_polling_task,0,"polling_task") < 0 )
			break;
	}
	polling_task_flag = 1;
	wakeup_task((int)v_loop2);
}

void
v_loop()
{
	create_task(polling_task,0,PRI_USER_INTERFACE);
	change_pri(0,PRI_USER_INTERFACE);
	v_loop2();
}


} // extern "C"