/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"win_flame.h"
#include	"heuristics_win_frame.h"
#include	"pri_level.h"


int
nwf_assert()
{

	assert_ls_all(LSF_ASSERT);
	return 0;
}

int
new_win_flame(
	WF_ID *		ret_wfid,
	GBVIEW_FLAME * gf,
	REAL1		v_reso,
	RESOURCE * 	draw,
	MAP_HISTORY * 	mh,
	GB_POINT	center,
	REAL1		rotate,
	REAL1		resolution)
{
WIN_FLAME_TABLE * tbl;
int ret;
int pri;
	pri = push_pri(PRI_DRAW);
	wf_lock(gf);
	ZONBIE_CHECK(gf,(wf_unlock(gf),change_pri(0,pri)),0)
	wf_unlock(gf);

	lr_extend(draw,nwf_assert);

	if ( gf->flame_base == 0 ) {
		tbl = wf_geo_type_list[
			draw->c.geometory_type>>GT_T_SHIFT]
			[WFT_STD];
	}
	else {
		tbl =
		wf_geo_type_list[
			gf->flame_base->draw->c.geometory_type>>GT_T_SHIFT]
			[WFT_STD];
	}
	ret = (*tbl->f_new)(
			tbl,
			gf,
			ret_wfid,
			v_reso,
			draw,
			mh,
			center,
			rotate,
			resolution);
	wf_lock(gf);
	wf_unlock(gf);
	wakeup_at_redraw_wp(gf);
	call_flame_insert_event(gf);
	wakeup_hwf(gf,HWFF_TYPE_TO_FRAME);
	
	change_pri(0,pri);
	return ret;
}


int
exit_win_flame(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;
	ret = (*wf->tbl->f_exit)(gf,wf);
	return ret;
}

int
win_flame_move(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT from,VPOINT to,void * ix)
{
WIN_FLAME_TABLE * tbl;
int geo_type,wf_type;
	if ( wf->flags & WFF_FREE )
		return -1;
//	return (*wf->tbl->f_move)(gf,wf,from,to,ix);

	geo_type = gf->flame_base->tbl->geo_type;
	wf_type = wf->tbl->wf_type;
	tbl = wf_geo_type_list[geo_type][wf_type];
	return (*tbl->f_move)(gf,wf,from,to,ix);
}


int
_change_win_flame(GBVIEW_FLAME * gf,WIN_FLAME * wf,int geo_type,int wf_type)
{
WIN_FLAME_TABLE * tbl;
int ret;
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( geo_type && geo_type != wf->tbl->geo_type )
		goto next;
	if ( wf_type && wf_type != wf->tbl->wf_type )
		goto next;
	return -1;
next:
	if ( geo_type && wf_type )
		tbl = wf_geo_type_list[geo_type][wf_type];
	else if ( geo_type )
		tbl = wf_geo_type_list[geo_type][wf->tbl->wf_type];
	else	tbl = wf_geo_type_list[wf->tbl->geo_type][wf_type];
	ret = (tbl->f_change)(tbl,gf,wf);
	return ret;
}

int
change_win_flame(GBVIEW_FLAME * gf,WIN_FLAME * wf,int geo_type,int wf_type)
{
int ret;
	wf_lock(gf);
	ret = _change_win_flame(gf,wf,geo_type,wf_type);
	wf_unlock(gf);
	return ret;
}

int
win_flame_redraw(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
int ret;

	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl == 0 )
		return -1;
	if ( wf->tbl->f_flame_redraw == 0 )
		return 0;

//	wf_set_delay_redraw_flag(gf,1);
	ret = (*wf->tbl->f_flame_redraw)(gf,wf);
//	wf_set_delay_redraw_flag(gf,0);
	return ret;
}

int
_win_flame_dirty(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT * r,int flags,int mode)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl == 0 )
		return -1;
	if ( wf->tbl->f_dirty == 0 )
		return 0;
	if ( flags & WFF_LS_DIRTY )
		wf->flags |= WFF_LS_DIRTY;
	return (*wf->tbl->f_dirty)(gf,wf,r,flags,mode);
}

int
win_flame_dirty(GBVIEW_FLAME * gf,WF_ID wfid,GB_RECT * r,int flags,int mode)
{
int ret;
WIN_FLAME * wf;
	wf_lock(gf);
	wf = _get_wf_ptr(gf,wfid);
	if ( wf )
		ret = _win_flame_dirty(gf,wf,r,flags,mode);
	else	ret = -1;
	wf_unlock(gf);
	return ret;
}

int
win_flame_overlay(GBVIEW_FLAME * gf,WIN_FLAME * wf,OV_ARG * a)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_overlay == 0 )
		return 0;
	return (*wf->tbl->f_overlay)(gf,wf,a);
}

int
win_flame_zoom(GBVIEW_FLAME * gf,WIN_FLAME * wf,int w,int h,int * ix_x,int * ix_y)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_zoom == 0 )
		return 0;
	return (*wf->tbl->f_zoom)(gf,wf,w,h,ix_x,ix_y);
}

int
win_flame_resize(GBVIEW_FLAME * gf,WIN_FLAME * wf,int old_width,int old_height)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_resize == 0 )
		return 0;
	return (*wf->tbl->f_resize)(gf,wf,old_width,old_height);
}


int
win_flame_rotate(GBVIEW_FLAME * gf,WIN_FLAME * wf,VPOINT * ix)
{
	if ( wf->flags & WFF_FREE )
		return -1;
	if ( wf->tbl->f_rotate == 0 )
		return 0;
	return (*wf->tbl->f_rotate)(gf,wf,ix);
}

void
set_weight(GBVIEW_FLAME * gf,WIN_FLAME * wf)
{
GV_RESOURCE_LIST * rl;
	if ( wf->tbl->f_get_weight ) {
		(*wf->tbl->f_get_weight)(gf,wf);
	}
	else {
		rl = search_resource_list(gf,wf->draw,0,1);
		if ( rl ) {
			if ( wf->flags & WFF_LUSTER )
				rl->weight = W_E2D_LUSTER;
			else if ( wf->flags & WFF_POLY )
				rl->weight = W_E2D_POLY;
			else	rl->weight = W_E2D_PLOT;
		}
	}
}

void
wf_setup_drawrect(GBVIEW_FLAME * gf,WIN_FLAME * wf,GB_RECT r,float rate)
{
	if ( wf->tbl->f_wf_setup_drawrect )
		(*wf->tbl->f_wf_setup_drawrect)(gf,wf,r,rate);
}

