/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___GEO_H___
#define ___GEO_H___

typedef struct elipsoid {
	double		a;
	double		b;
	double		e;
	double		e2;

	double		m0;
	double		org_X0;
	double		org_Y0;
	double		org_X;
	double		org_phi;
	double		org_lambda;
	unsigned	org_X_enable:1;
} ELIPSOID;

void
utm2bl(double * X_ptr,double * Y_ptr,double lambda,double phi,ELIPSOID * ep);

#define SCALE_CONSTANT	0.9996

void
print_elipsoid(ELIPSOID * ep);
int load_dted1(short * data,int * org_east,int * org_north,
		int * line_nos_p,
	       char *dir_name,char *filename,int cmd);

#define DTED1_BLOCK_SIZE	1201
#define DTED1_HALF_SIZE		601

/* cmd */
#define DTED1_CMD_BASE		0x0f
#define DTED1_CMD_OPT		0xf0
#define DTED1_CMD_POS		1
#define DTED1_CMD_DIRECT	2
#define DTED1_CMD_ROUND		3
#define DTED1_CMD_INTP		0x10

#endif
