/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___PDB64_H___
#define ___PDB64_H___


#include	"pdb64_basic.h"
#include	"machine/include.h"


/*******************************

	MATRIX FILE FORMAT

*******************************/

#include	"matrix.h"


#define MI_MODE_DIRECT	0
#define MI_MODE_SERVER	1
#define MI_MODE_CLIENT	2
#define MI_MODE_MAX	3

#define FAT_MX_NODE	0x401

typedef struct mx_dim_code {
	INTEGER64		fofs;
} MX_DIM_CODE;

typedef struct _pn64_mx_channel_info {
	short			data_type;
	short			flags;

	INTEGER64		default_data_fofs;
				/* default data (DATA_1) */
} _PN64_MX_CHANNEL_INFO;


typedef struct pn64_mx_header {
	PN64_HEADER	h;

	/* corresponding to matrix_param */

	int			channel_nos;
	int			dim;
	int			flags;
	int			total_levels;
	
	INTEGER64		modify_time;

	INTEGER64		subheader_fofs;

	/* variable tail */
	/* dim_divide (dim * sizeof(char)) */
	/* block_size (dim * sizeof(char)) */
	/* pixel_size (dim * sizeof(INTEGER64) */
	/* channel_info */
	/* (channel_nos * sizeof(_PN64_MX_CHANNEL_INFO)) */
} PN64_MX_HEADER;

typedef struct pn64_mx_subheader {
	PN64_HEADER		h;
	int			mode_pri_area[MI_MODE_MAX][MI_MAX];
	INTEGER64		mode_cal_fofs[MI_MODE_MAX][MI_MAX];
	INTEGER64		node_root;
	INTEGER64		cache_next;
	INTEGER64		cache_prev;
	int			cache_count;
	int			flags;
#define MXF_WRITE		0x00000001
} PN64_MX_SUBHEADER;

typedef struct pn64_mx_data_1 {
	PN64_HEADER		h;

	/* block of mx_data */
} PN64_MX_DATA_1;

typedef struct pn64_mx_data_2 {
	PN64_HEADER		h;
	INTEGER64		next_fofs;
	int			id;

	/* block of mx_data */
} PN64_MX_DATA_2;

typedef struct pn64_mx_cal {
	PN64_HEADER		h;

	/* sexp utf8 string ; zero terminated */
} PN64_MX_CAL;

typedef struct pn64_mx_cache_ring {
	PN64_HEADER		h;
	INTEGER64		node;
	INTEGER64		next;
	INTEGER64		prev;
} PN64_MX_CACHE_RING;

typedef struct pn64_mx_dim_addr {
	PN64_HEADER		h;

	/* dim_code list */
} PN64_MX_DIM_ADDR;

typedef struct _pn64_mx_node_cache {
	INTEGER64	ring_fofs;
} _PN64_MX_NODE_CACHE;

typedef struct _pn64_mx_node_field {
	INTEGER64	nlist_dim_addr;
} _PN64_MX_NODE_FIELD;


typedef struct pn64_mx_node {
	PN64_HEADER		h;
	INTEGER64		channel_fofs;
	union {
		struct {
			unsigned char	end_pos;
		} p0;
		struct {
			_PN64_MX_NODE_CACHE c;
			unsigned char	end_pos;
		} p1;
		struct {
			_PN64_MX_NODE_FIELD f;
			unsigned char	end_pos;
		} p2;
		struct {
			_PN64_MX_NODE_CACHE c;
			_PN64_MX_NODE_FIELD f;
			unsigned char	end_pos;
		} p3;
	} d;

	/* dim_code */
	/* nlist bit field */
} PN64_MX_NODE;

void
change_endian_phys_header64_to_host(PHYS_PN64_HEADER * h);
void
change_endian_phys_header64_to_net(PHYS_PN64_HEADER * h);
void
change_endian_header64(PN64_HEADER * h);
void
change_endian_file_header64(PN64_FILE_HEADER * f);

PDB64 * open_pdb64(char * filename,int oflags,int mode,int flags);
void close_pdb64(PDB64 *);
void check_pdb64(PDB64 * p);


#endif

