/**********************************************************************
 
	Copyright (C) 2007 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___PG_VECTOR_H___
#define ___PG_VECTOR_H___

#include	"xl.h"
#include	"matrix.h"
#include	"simple_alloc.h"

/* PLOT DATA STRUCTURE */

/* PRIMITIVE PLOT DATA STRUCTURE */


typedef struct primitive_plot {
	unsigned char		flags;
#define PP_END			0x00

#define PP_KIND			0x03
#define PP_PRIMITIVE		0x01
#define PP_DIFFERENCE		0x02
#define PP_ERR			0x03
#define PP_ALL_FIELDS_INHERIT	0x04
#define PP_MERGED_FIELDS	0x08
#define PP_START_POINT		0x10
#define PP_BASE			0x20
#define PP_ID			0x40
	unsigned char		dummy;
	unsigned short		c[1];
	/* dimension length of short */
	/* if PP_BASE is active, dimension length of INTEGER64 for base */
	/* if PP_ID is active, 64bit ID */
#define PPID_INDEFINE		0
#define PPID_INHERIT		1
	/* field strings terminated NULL char */
	/* field string = CH-TYPE-CODE + string */
	/* NULL char */
} PRIMITIVE_PLOT;



#define CH_TYPE_MASK		0xf0
#define CH_TYPE_SHIFT		4
#define CH_TYPE_NONE		0x10
#define CH_TYPE_STRING		0x20
#define CH_TYPE_INT		0x30
#define CH_TYPE_RGBA		0x40

#define CH_NONE			0x10

#define CH_STRING		0x20
#define CH_STRING_INHERIT	0x21
#define CH_STRING_ERASE		0x22

#define CH_INT_ADD		0x31
#define CH_INT_AVG		0x32
#define CH_INT_MAX		0x33
#define CH_INT_MIN		0x34

#define CH_RGBA			0x40

#define LABEL_POINT_COLOR	0
#define LABEL_POINT_IMG		1

typedef struct field_rgba_t {
	unsigned char		rgba[4];
	INTEGER64		count;
} FIELD_RGBA_T;

typedef struct ip_field {
	unsigned		len:24;
	unsigned char		type;
	union {
		char *			str;
		INTEGER64 *		i;
		FIELD_RGBA_T *		rgba;
	} d;
} IP_FIELD;



typedef struct internal_plot {
	struct internal_plot *	next;
	struct internal_plot *	prev;
	unsigned char		flags;
	unsigned short *	c;
	INTEGER64 *		base;
	IP_FIELD *		fields;
	INTEGER64		id;
	
	int			min_direction;

	MATRIX_SEXP *		onmap;
	MATRIX_SEXP *		card;
} INTERNAL_PLOT;


/* STRUCTURED BLOCK */

typedef struct pp_sb_new {
	void *			data;
	int			size;
	int			flags;
#define PPF_COMPRESSED		0x00000001
#define PPF_SAT			0x00000002
} PP_SB_NEW;

#define PPC_INSERT		1
#define PPC_DELETE		2
#define PPC_SORT		3
#define PPC_DIVIDE_CHECK	4
#define PPC_GET_AND_CLEAR	5
#define PPC_GET			6
#define PPC_SET			7
#define PPC_DENSITY		8
#define PPC_ARRAY		9
#define PPC_FREE_ARRAY		10

typedef struct ppc_insert_t {
	INTEGER64		level;
	INTEGER64 *		crd;
	IP_FIELD *		fields;
} PPC_INSERT_T;

typedef struct fd_opt_header {
	union fd_opt *		next;
	int			csv_label;
	int			dim;
	int			target_label;
	unsigned char		merge_type;
	XL_SEXP *		init_sexp;
} FD_OPT_HEADER;

typedef struct fd_none_opt {
	FD_OPT_HEADER		h;
} FD_NONE_OPT;

typedef struct fd_str_opt {
	FD_OPT_HEADER		h;
	XL_SEXP *		convert;
	CODE_METHOD *		cm;
} FD_STR_OPT;

typedef struct fd_int_opt {
	FD_OPT_HEADER		h;
	int			type;
#define FDIT_INT		1
#define FDIT_FLOAT		2
#define FDIT_DD			3
#define FDIT_DDMMSS		4
	double			reso;
	INTEGER64		offset;
	INTEGER64		count;
} FD_INT_OPT;

typedef struct fd_rgba_opt {
	FD_OPT_HEADER		h;
	INTEGER64		count;
} FD_RGBA_OPT;

typedef union fd_opt {
	FD_OPT_HEADER		h;
	FD_NONE_OPT		none;
	FD_STR_OPT		str;
	FD_INT_OPT		i;
	FD_RGBA_OPT		rgba;
} FD_OPT;

typedef struct fd_opt_ptr {
	FD_OPT *		opt;
	struct matrix *		m;
	int			last_label;
	int			startline;
} FD_OPT_PTR;


typedef struct field_type {
	int (*initial)(struct ip_field*,void *,void*opt,int);
	void (*copy)(struct ip_field*,struct ip_field*,SIMPLE_ALLOC_T * sat);
	void (*merge)(struct ip_field*,struct ip_field*,struct ip_field*);
	void (*diff)(struct ip_field*,struct ip_field*,struct ip_field*);
	void (*add)(struct ip_field*,struct ip_field*,struct ip_field*,SIMPLE_ALLOC_T * sat);
	unsigned char* (*to_internal)(struct ip_field*,unsigned char*p,SIMPLE_ALLOC_T * sat);
	unsigned char* (*to_external)(struct ip_field*,unsigned char*p);
	int (*size)(struct ip_field*);
	int (*cmp)(struct ip_field*,struct ip_field*);
	void (*gc)(union fd_opt*);
} FIELD_TYPE;


void init_mxPgPlot(XLISP_ENV * env);
XL_SEXP*
gb_gmxPgPlotInsert(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV* a,XL_SYM_FIELD * sf);
void
init_gmxPgPlotInsert(XLISP_ENV * env0,XLISP_ENV * env1);
void
init_gmxPgPlotField(XLISP_ENV * env0,XLISP_ENV * env1);
void
free_fields(IP_FIELD * fd);
void
gc_fd_opt_ptr();
void
gc_fd_opt();
INTERNAL_PLOT *shift_under_plot(MATRIX*,INTERNAL_PLOT *,INTEGER64 level,INTEGER64 * dc);
void
free_internal_plot(INTERNAL_PLOT * ip);
void
free_internal_plot_list(INTERNAL_PLOT * ip);
INTERNAL_PLOT*
code2internal(MATRIX * m,PRIMITIVE_PLOT*ptr,int ptr_size,SIMPLE_ALLOC_T * sat);
PRIMITIVE_PLOT *
internal2code(int * size_p,MATRIX * m,INTERNAL_PLOT*ip);
void
init_gmxPgDisplay(XLISP_ENV * env0,XLISP_ENV * env1);
void
get_plot_crd(INTEGER64 * crd,MATRIX * m,INTERNAL_PLOT * ip,INTEGER64 level);
void
init_pg_vector(XLISP_ENV * env);


extern FIELD_TYPE field_type_tbl[];
extern MX_STRUCT_BLOCK_TBL blk_pp_tbl;

#endif

