/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_V_TYPES_H___
#define ___V_V_TYPES_H___

#include	"machine/v_m.h"
#include	<stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

#include	"long_char.h"
#include	"v/v_graph.h"
#include	"queue.h"

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
class VObject;
#include	"VSemaphore.h"
#else
typedef void VObject;
#ifndef ___XcodeCW
typedef unsigned char bool;
#endif
typedef void VSemaphore;
#endif

/*#ifdef __cplusplus
class VCursor;
#else
*/
typedef void VCursor;
/*
#endif
*/

/*
typedef struct VPoint {
	short x;
	short y;
} VPoint;
*/

typedef struct VSize {
	short w;
	short h;
} VSize;

/*
typedef struct VRect {
	short l;
	short t;
	short r;
	short b;
} VRect;
*/

typedef S_RECT VRect;

typedef void(*V_CALLBACK_T)(VObject*,void*,void*);
#define V_CALLBACK(f)	void(*f)(VObject*,void*,void*)
#define V_CALLBACK_D(f)	void f(VObject *object, void *user_arg, void *sys_arg)

// object types

#define VO_VOBJ		32767
#define VO_WIND		1
#define VO_SCRV		2
#define VO_GRPV		3
#define VO_HGRV		4
#define VO_VGRV		5
#define VO_TBLV		6
#define VO_VBTN		7
#define VO_PUSH		8
#define VO_CHKB		9
#define VO_RADB		10
#define VO_POPB		11
#define VO_STXT		12
#define VO_SLID		13
#define VO_DRAW		14
#define VO_EDRW		15
#define VO_ETXT		16
#define VO_SEPR		17
#define VO_HSPR		18
#define VO_VSPR		19
#define VO_GBOX		20
#define VO_TABV		21
#define VO_TREV		22
#define VO_PRGB		23
#define VO_SPLV		24
#define VO_HSPV		25
#define VO_VSPV		26
#define VO_BGCV		27
#define VO_FCSV		28

#define VO_MACR		(0x1000)

#define VO_XTXT		(0x2000+1)
#define VO_XELN		(0x2000+2)
#define VO_XTRV		(0x2000+3)

#define VO_GFLM		(0x4000+1)
#define VO_GIND		(0x4000+2)
#define VO_GQIN		(0x4000+3)
#define VO_WPME		(0x4000+4)
#define VO_GPSB		(0x4000+100)

#define V_MODKEY_SHIFT	0x01
#define V_MODKEY_CAPS	0x02
#define V_MODKEY_ALT	0x04	// alt / Mac option
#define V_MODKEY_CTRL	0x08	// ctrl / Mac command
#define V_MODKEY_META	0x10	// Meta / Mac ctrl

#define V_BUTTON_1	0x01
#define V_BUTTON_2	0x02
#define V_BUTTON_3	0x04
#define V_BUTTON_4	0x08
#define V_BUTTON_5	0x10


typedef struct VImage {
	long *			buf_32;
	VSize			size;
	short			w_border;
	
	short			ref_cnt;
	char			drawing;
	VImageInfo	info;

	int			tid;
	char *			in_file;
	int			in_line;
	char *			out_file;
	int			out_line;
} VImage;

typedef struct VIconButtonSet
{
	VImage *	on;	// I
	VImage *	off;	// I
	VImage *	select;	// ܂ꂽ
} VIconButtonSet;

typedef struct VObjectList {
	VObject *				object;
	struct VObjectList *	next;
} VObjectList;

#define VSF_PARENT		(1 << 0)
#define VSF_CHILDREN		(1 << 1)
#define VSF_ID			(1 << 2)
#define VSF_ATTR		(1 << 3)
#define VSF_VALUE		(1 << 4)
#define VSF_WS			(1 << 5)
#define VSF_FSIZE		(1 << 6)
#define VSF_DESC		(1 << 7)
#define VSF_VERTD		(1 << 8)
#define VSF_VISIBLE		(1 << 9)
#define VSF_ENABLED		(1 << 10)
#define VSF_HOMOGEN		(1 << 11)
#define VSF_SPACING		(1 << 12)
#define VSF_ALIGN		(1 << 13)
#define VSF_PADDING		(1 << 14)
#define VSF_CURSOR		(1 << 15)
#define VSF_VALUE_EH		(1 << 16)
#define VSF_DESC_EH		(1 << 17)
#define VSF_DESTROY_H		(1 << 18)
#define VSF_FOCUS		(1 << 19)

#define VSF_MIN_SIZE		(1 << 24)
#define VSF_SIZE		(1 << 25)
#define VSF_POSITION		(1 << 26)
#define VSF_CALC_MIN		(1 << 27)
#define VSF_LAYOUT		(1 << 28)

#define VSF_ALL_FLAGS		0x1F0FFFFF
#define VSF_DEF_FLAGS		0x0000FFF8

typedef struct VObjectStatus {
	VObject *		window;
	VObject *		parent;
	VObjectList *		children;
	
	int			id;		// object ID (sequence No.)
	int			attr;		// object attr. defined by subclass
	int			value;		// object value
	const LC_WRITING_STYLE * ws;		// writing_style of descriptor
	int			fsize;		// writing font size
	const L_CHAR*		descriptor;		// label of object 
	unsigned		vert_desc : 1;	// verticaly drawn 
						// but only supported obj.
	bool			visible : 1; 	// show / hide
	bool			enabled : 1;	// usable / unusable by gray indicate
	
	bool			homogeneous : 1;// make children same size
	bool			focused:1;
	VSize			spacing;	// make span between children
	
	unsigned		alignv  : 2;	// alaignment of this object
	unsigned		alignh  : 2;	// alaignment of this object
#define VALIGN_LEFT	0
#define VALIGN_TOP	0
#define VALIGN_RIGHT	1
#define VALIGN_BOTTOM	1
#define VALIGN_EXPAND	2
#define VALIGN_FILL	3
	VSize			padding;	// make space at each side of this obj.
	
	// pointer shape if it on this obj.
	VCursor * 		cursor;
	
	// event handler

		// invoked when a value is changed
	V_CALLBACK		(value_event_handler);
	void *			value_eh_arg;

		// invoked when the descripter is changed
	V_CALLBACK		(descriptor_event_handler);
	void *			desc_eh_arg;

		// invoked before the object is destroyed
	V_CALLBACK		(destroy_handler);
	void *			destroy_h_arg;
	
	VSize			min_size;	// minimum size of this obj..
	VSize			size;		// size of this obj.
	VPoint			position;	// position of this obj.
} VObjectStatus;

typedef struct VObjectAppStatusAry {
	void *		sts;
	int		flags;
} VObjectAppStatusAry;

#ifdef __cplusplus

const VSize v_default_spacing = {V_DEFAULT_SPACING,V_DEFAULT_SPACING};
const VSize v_default_padding = {V_DEFAULT_PADDING,V_DEFAULT_PADDING};
const int MAX_CHILDREN_NO_LIMIT = 0x7fffffff;
const short V_DEFAULT_SIZE = -1;
const short V_DEFAULT_POS = -1;

const VSize v_default_size = {V_DEFAULT_SIZE, V_DEFAULT_SIZE};
const VPoint v_default_pos = {V_DEFAULT_POS, V_DEFAULT_POS};

const VObjectStatus v_default_sts = 
{
	0,0,0, 0,0,0,0,V_DEFAULT_FSIZE,0,0, 1,1,
	0,0,{v_default_spacing.w,v_default_spacing.h}, 
	VALIGN_EXPAND,VALIGN_EXPAND, 
	{v_default_padding.w,v_default_padding.h},
	0,0,0,0,0,0,0,
	{v_default_size.w,v_default_size.h},
	{v_default_size.w,v_default_size.h},
	{v_default_pos.x,v_default_pos.y}
};


const int	V_OBJECT_ZONBIE_INTERVAL = 1;	// 10
const int	V_OBJECT_ZONBIE_DELAY = 300;
const int	V_OBJECT_ALIVE = 0x7fffffff;

#endif

typedef struct VQueEventHandler {
	Q_HEADER	h;
	V_CALLBACK	(handler);
	VObject *	object;
	void * 		usr_arg;
	void *		sys_arg;
	int		sys_arg_size;

	char *		__file;
	int		__line;
} VQueEventHandler;


typedef struct descriptor_list {
	struct descriptor_list *	next;
	L_CHAR *			desc;
	int				len;
	char *				machine_desc;
	int				machine_desc_len;
	int				no;
} DESCRIPTOR_LIST;

// ======= prototypes of these types handler =======

#ifdef __cplusplus
extern "C" {
#endif

VObjectList* vobject_list_remove(VObjectList *target, VObjectList *prev, VObjectList **top); // returns next
void free_vobject_status(VObjectStatus *s);
L_CHAR* v_make_vert_desc(const L_CHAR* desc);
L_CHAR* v_copy_desc_temp(const L_CHAR* desc);

//  VImage handler
VImage* v_image_new(short w, short h, char depth);
VImage* v_image_ref(VImage* img);
VImage* v_image_unref(VImage* img);
void v_image_free(VImage* img);
VImage* v_image_copy(VImage* img);
VImage* v_image_partial(VImage* img, VRect *r);
int _v_image_draw_start(VImage* img, int no_block, char *file, int line);
void _v_image_draw_end(VImage* img, char * file, int line);

#define v_image_draw_start(img, b)	_v_image_draw_start(img, b, (char*)__FILE__, __LINE__)
#define v_image_draw_end(img)	_v_image_draw_end(img, (char*)__FILE__, __LINE__)


void convert_to_nmc_list(VObjectList **l);

void copy_vobject_status(VObjectStatus *,const VObjectStatus *,int);
void free_vobject_status_copy(VObjectStatus *);

void xx_vq_insert_callback(
		VObject *object,
		V_CALLBACK(handler),
		void *usr_arg,
		void *sys_arg,
		int sys_arg_size,
		char * skey,
		char *,int);
#define vq_insert_callback(object,handler,usr_arg,sys_arg,sys_arg_size,skey)	\
		xx_vq_insert_callback(object,handler,usr_arg,sys_arg,sys_arg_size, \
					skey, \
					(char*)__FILE__,__LINE__)

extern LC_FONT_ENGINE_TYPE *vobj_fet[];

int vobject_init_gb(int * argc,char *** argv);
void init_vobj_function_gb();
void init_vobj_function_xl();
void gc_vobj_utils_lock();
void gc_vobj_utils_unlock();
void gc_vobj_utils();


typedef struct init_func_list {
	struct init_func_list *	next;
	int (*func)(int * argc,char *** argv,struct init_func_list * flist);
	void *	work;
} INIT_FUNC_LIST;

int _vobject_init(int * argc,char *** argv,
		INIT_FUNC_LIST * func);
int vobject_init(int *argc, char ***argv);
int _vobject_init_xl(int * argc,char *** argv,
		INIT_FUNC_LIST * func);
int vobject_init_xl(int * argc,char *** argv);
int vobject_init_gb(int * argc,char *** argv);
int _vobject_init_gb(int * argc,char *** argv,INIT_FUNC_LIST * flist);
int vobject_main();
void vobject_layout();
void init_vobj_function_xl();
void init_vobj_VgbFlameStandard(XLISP_ENV *env);
void init_vobj_VgbIndicate(XLISP_ENV *env);
void init_vobj_VgbGPSBrowser(XLISP_ENV *env);
void init_vobj_function();
void init_vobj_utils(XLISP_ENV *env);
void init_VDestroy(XLISP_ENV *env);
void init_VAlignView(XLISP_ENV *env);
void init_VTableView(XLISP_ENV *env);
void init_VSplitView(XLISP_ENV *env);
void init_VTabView(XLISP_ENV *env);
void init_VButton(XLISP_ENV *env);
void init_VEditText(XLISP_ENV *env);
void init_VGroupBox(XLISP_ENV *env);
void init_VScrollView(XLISP_ENV *env);
void init_VSeparator(XLISP_ENV *env);
void init_VSlider(XLISP_ENV *env);
void init_VStaticText(XLISP_ENV *env);
void init_VWindow(XLISP_ENV *env);
void init_VDraw(XLISP_ENV *env);
void init_VexDraw(XLISP_ENV *env);
void init_VTreeView(XLISP_ENV *env);
void init_VProgressBar(XLISP_ENV *env);
void init_VBackColorView(XLISP_ENV *env);
void init_VMenu(XLISP_ENV *env);
void init_VChooseFile(XLISP_ENV *env);
void init_VgbFlameStandard();
void init_vobj_VgbQueryIndicate(XLISP_ENV *env);
void init_vobj_status(XLISP_ENV *env);
void init_vobj_VxlLoadingVDraw(XLISP_ENV *env);

XL_SEXP * vobj_GetStatus(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);
XL_SEXP * vobj_SetStatus(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);
XL_SEXP * vobj_vobjTarget(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);
XL_SEXP * vobj_vobjWaitSync(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV*,XL_SYM_FIELD*);
void init_vobj_status(XLISP_ENV *env);
XL_SEXP * vobj_GetObjectID(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);
XL_SEXP * vobj_Quit();
XL_SEXP * vobj_Layout();
void init_vobj_utils(XLISP_ENV *env);
XL_SEXP * get_ex_flags_pos(int flags,const char * msg);
VRect get_elr_1(char * data);
char * _get_elr_2(int * vp,int * hp,char * data);
VRect get_elr_2(char * data,VImage * img);
VRect get_elr_spot(VSize size,int v,int h,int ptr_v,int ptr_h);
void init_VMacro();
void init_vobj_VxlText(XLISP_ENV *env);
void init_vobj_VxlEditLine(XLISP_ENV *env);
void init_vobj_VxlTreeView(XLISP_ENV *env);
void free_el_data(L_CHAR ** data);
L_CHAR ** copy_el_data(L_CHAR ** data);
void init_vobj_VgbWPMenuEdit(XLISP_ENV *env);


void VMacro_gc();
void VMacro_gc_lock();
void VMacro_gc_unlock();


#ifdef __cplusplus
}
#endif

#endif
