/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"change_endian.h"
#include	"xl.h"
#include	"memory_debug.h"
#include	"pdb64.h"
#include	"favt64.h"
#include	"filespace64.h"
#include	"dtree64.h"
#include	"associate64.h"


void gc_gb_sexp();

ASSOC64_KEY	as_key64[ASSOC_KEY_NO];


void
integer_endian64(int * a)
{
	change_endian_i(*a);
}

int
cmp_assoc64_integer(int * a,int * b)
{
	if ( *a < *b )
		return -1;
	if ( *a > *b )
		return 1;
	return 0;
}

void
change_endian_assoc64_index(ASSOC64_INDEX * ix)
{
	change_endian(ix->fofs);
	change_endian_s(ix->type);
	change_endian_s(ix->name);
}

void
change_endian_assoc64_header_to_net(PN64_ASSOC_HEADER * h)
{
int len;
int i;
	len = (h->h.size - PN64_ASSOC_HEADER_S(0))/sizeof(ASSOC64_INDEX);
	for ( i = 0 ; i < len ; i ++ )
		change_endian_assoc64_index(&h->ix[i]);
	change_endian_header64(&h->h);
}

void
change_endian_assoc64_header_to_host(PN64_ASSOC_HEADER * h)
{
int len;
int i;
	change_endian_header64(&h->h);
	len = (h->h.size - PN64_ASSOC_HEADER_S(0))/sizeof(ASSOC64_INDEX);
	for ( i = 0 ; i < len ; i ++ )
		change_endian_assoc64_index(&h->ix[i]);
}

void
change_endian_assoc64_data(PN64_ASSOC_DATA * d)
{
	change_endian_header64(&d->h);
}

int
open_associate64(
	char * filename,
	int oflags,
	int mode,
	int flags,
	int type,
	char * encoding)
{
int key;
U_INTEGER64 fofs;
void * ptr;

	for (  key = 1 ; as_key64[key].p && key < ASSOC_KEY_NO ; key ++ );
	if ( key == ASSOC_KEY_NO )
		return -1;
	as_key64[key].p = open_filespace64(
		filename,oflags,mode,flags,type,encoding,0,0);
	if ( as_key64[key].p == 0 )
		return -1;
	as_key64[key].fheader = read_filespace64(as_key64[key].p,0);
	change_endian_file_header64(&as_key64[key].fheader->d);
	fofs = 0;
	ptr = get_file_record64(&fofs,as_key64[key].p,PNT_ASSOC_HEADER,0);

	if ( ptr == 0 ) {
		as_key64[key].assoc = 0;
		as_key64[key].assoc_len = 0;
	}
	else {
		d_f_ree(ptr);
		as_key64[key].assoc = read_filespace64(as_key64[key].p,fofs);
		change_endian_assoc64_header_to_host(&as_key64[key].assoc->d);
		as_key64[key].assoc_len
			= (as_key64[key].assoc->d.h.size
			  - PN64_ASSOC_HEADER_S(0))/sizeof(ASSOC64_INDEX);
	}
	return key;
}

void
close_associate64(int key)
{
	if ( key < 1 )
		return;
	if ( key >= ASSOC_KEY_NO )
		return;
	if ( as_key64[key].p == 0 )
		return;
	close_filespace64(as_key64[key].p);
	if ( as_key64[key].assoc )
		d_f_ree(as_key64[key].assoc);
	d_f_ree(as_key64[key].fheader);
	as_key64[key].assoc = 0;
	as_key64[key].assoc_len = 0;
	as_key64[key].fheader = 0;
	as_key64[key].p = 0;
}

int
new_index64(int key,short type,short name)
{
ASSOC64_INDEX * ix;
int i;
int ret;
	if ( key < 1 )
		return -1;
	if ( key >= ASSOC_KEY_NO )
		return -1;
	if ( as_key64[key].p == 0 )
		return -1;
	if ( as_key64[key].assoc == 0 ) {
		as_key64[key].assoc = d_alloc(
			PN64_ASSOC_HEADER_S(1)+sizeof(ACC64_HEADER));
		as_key64[key].assoc_len = 1;

		as_key64[key].assoc->a.fofs = 0;
		as_key64[key].assoc->d.h.type = PNT_ASSOC_HEADER;
		ix = as_key64[key].assoc->d.ix;
		ret = 0;
	}
	else {
		for ( i = 0 ; i < as_key64[key].assoc_len ; i ++ ) {
			if ( as_key64[key].assoc->d.ix[i].name == name )
				return -1;
		}
		ret = as_key64[key].assoc_len;
		as_key64[key].assoc_len++;
		as_key64[key].assoc = 
			d_re_alloc(as_key64[key].assoc,
				PN64_ASSOC_HEADER_S(ret+1)+
					sizeof(ACC64_HEADER));
		ix = &as_key64[key].assoc->d.ix[ret];
	}
	as_key64[key].assoc->d.h.size = PN64_ASSOC_HEADER_S(ret+1);
	ix->type = type;
	ix->name = name;
	switch ( type ) {
	case AIT_INTEGER:
		ix->fofs = favt64_alloc_root(
			as_key64[key].p,FAT_ASSOC_INTEGER,integer_endian64)
				->h.fofs;
		break;
	case AIT_STRING:
		ix->fofs = alloc64_dtree(as_key64[key].p,FAT_ASSOC_STRING)->h.fofs;
		break;
	default:
		er_panic("new_index");
	}
	if ( as_key64[key].assoc->a.fofs )
		free_filespace64(as_key64[key].p,
			as_key64[key].assoc->a.fofs);
	as_key64[key].assoc->a.fofs
		= alloc_filespace64(as_key64[key].p,
			&as_key64[key].assoc->d.h);
	change_endian_assoc64_header_to_net(&as_key64[key].assoc->d);
	write_filespace64(as_key64[key].p,
		as_key64[key].assoc);
	change_endian_assoc64_header_to_host(&as_key64[key].assoc->d);
	return ret;
}


int
get_index64(int key,short name)
{
int ret;
	if ( key < 1 )
		return -1;
	if ( key >= ASSOC_KEY_NO )
		return -1;
	if ( as_key64[key].p == 0 )
		return -1;
	for ( ret = 0 ; ret < as_key64[key].assoc_len ; ret ++ )
		if ( as_key64[key].assoc->d.ix[ret].name == name )
			return ret;
	return -1;
}

int
get_index_type64(int key,int index)
{
	if ( key < 1 )
		return -1;
	if ( key >= ASSOC_KEY_NO )
		return -1;
	if ( as_key64[key].p == 0 )
		return -1; 
	if ( index < 0 )
		return -1;
	if ( index >= as_key64[key].assoc_len )
		return -1;
	return as_key64[key].assoc->d.ix[index].type;
}

U_INTEGER64
alloc64_data(PDB64 * p,char * dd)
{
ACC64_PN_ASSOC_DATA * dt;
int len;
U_INTEGER64 ret;

	len = strlen(dd)+1;
	if ( len < 8 )
		len = 8;
	dt = d_alloc(PN64_ASSOC_DATA_S(len)+sizeof(ACC64_HEADER));
	dt->d.h.type = PNT_ASSOC_DATA;
	dt->d.h.size = PN64_ASSOC_DATA_S(len);
	strcpy(dt->d.data,dd);
	ret = dt->a.fofs = alloc_filespace64(p,&dt->d.h);
	change_endian_assoc64_data(&dt->d);
	write_filespace64(p,dt);
	d_f_ree(dt);
	return ret;
}

int
insert_assoc64_integer(PDB64 * p,ASSOC64_INDEX * ix,void * from,char * dd)
{
FAVT64_NODE * n, * nn;
FAVT64_ROOT * r;
ASSOC64_INTEGER in, * inp;
int err;

	in.data = *(int*)from;
	r = get_root64(&err,p,ix->fofs,integer_endian64);
	n = favt64_search(&err,r,root_node64(&err,r),&in,cmp_assoc64_integer,0);
	if ( n ) {
		inp = n->data;
		free_filespace64(p,inp->fofs);
		inp->fofs = alloc64_data(p,dd);
		n->h.flags |= FAF_DIRTY;
	}
	else {
		in.fofs = alloc64_data(p,dd);
		n = favt64_alloc_node(r,&in,sizeof(in));
		nn = favt64_insert(&err,r,&r->node,n,cmp_assoc64_integer,0);
		if ( nn != n )
			er_panic("assoc_insert_integer");
	}
	return 0;
}

int
insert_assoc64_string(PDB64 * p,ASSOC64_INDEX * ix,void * from,char * dd)
{
FAVT64_ROOT * r;
U_INTEGER64 old,new;
int size;
int err;

	r = get_root64(&err,p,ix->fofs,dtree64_endian);
	old = search_dtree64(&err,&size,r,from,1);
	new = alloc64_data(p,dd);
	if ( insert_dtree64(&err,r,from,old,new) < 0 )
		er_panic("insert_assoc_string");
	if ( old )
		free_filespace64(p,old);
	return 0;
}

int
delete_assoc64_string(PDB64 * p,ASSOC64_INDEX * ix,void * from)
{
FAVT64_ROOT * r;
U_INTEGER64 old;
int size;
int err;

	r = get_root64(&err,p,ix->fofs,dtree64_endian);
	old = search_dtree64(&err,&size,r,from,1);
	if ( delete_dtree64(&err,r,from,0) < 0 )
		er_panic("insert_assoc_string");
	if ( old )
		free_filespace64(p,old);
	return 0;
}


int
insert_associate64(int key,int index,void * from,XL_SEXP * data)
{
ASSOC64_INDEX * ix;
STREAM * st;
char * dd;
int ret;
	if ( key < 1 )
		return -1;
	if ( key >= ASSOC_KEY_NO )
		return -1;
	if ( index < 0 )
		return -1;
	if ( index >= as_key64[key].assoc_len )
		return -1;
	ix = &as_key64[key].assoc->d.ix[index];
	st = s_open_string_write(search_cm(
		as_key64[key].fheader->d.encoding));
	if ( st == 0 )
		er_panic("insert_associate(1)");
	print_sexp(st,data,0);
	dd = s_get_string(st);
	if ( dd == 0 )
		er_panic("insert_associate(2)");
	switch ( ix->type ) {
	case AIT_INTEGER:
		ret = insert_assoc64_integer(as_key64[key].p,ix,from,dd);
		break;
	case AIT_STRING:
		ret = insert_assoc64_string(as_key64[key].p,ix,from,dd);
		break;
	default:
		er_panic("insert_associate(3)");
	}
	s_close(st);
	return ret;
}

int
delete_associate64(int key,int index,void * from)
{
ASSOC64_INDEX * ix;
int ret;
	if ( key < 1 )
		return -1;
	if ( key >= ASSOC_KEY_NO )
		return -1;
	if ( index < 0 )
		return -1;
	if ( index >= as_key64[key].assoc_len )
		return -1;
	ix = &as_key64[key].assoc->d.ix[index];
	switch ( ix->type ) {
	case AIT_INTEGER:
		ret = -1;
		break;
	case AIT_STRING:
		ret = delete_assoc64_string(as_key64[key].p,ix,from);
		break;
	default:
		er_panic("insert_associate(3)");
	}
	return ret;
}


ACC64_PN_ASSOC_DATA *
search_assoc64_integer(PDB64 * p,ASSOC64_INDEX * ix,void * from)
{
FAVT64_NODE * n;
FAVT64_ROOT * r;
ASSOC64_INTEGER in, * inp;
ACC64_PN_ASSOC_DATA * ret;
int err;

	in.data = *(int*)from;
	r = get_root64(&err,p,ix->fofs,integer_endian64);
	n = favt64_search(&err,r,
		root_node64(&err,r),&in,cmp_assoc64_integer,0);
	if ( n == 0 )
		return 0;
	inp = n->data;
	ret = read_filespace64(p,inp->fofs);
	change_endian_assoc64_data(&ret->d);
	if ( ret == 0 )
		er_panic("search_assoc64_integer");
	if ( ret->d.h.type != PNT_ASSOC_DATA )
		er_panic("search_assoc64_integer(2)");
	return ret;
}

ACC64_PN_ASSOC_DATA *
search_assoc64_string(PDB64 * p,ASSOC64_INDEX * ix,void * from,
	ASSOC64_STRING_OPT * option)
{
FAVT64_ROOT * r;
U_INTEGER64 fofs;
ACC64_PN_ASSOC_DATA * ret;
int err;

	r = get_root64(&err,p,ix->fofs,dtree64_endian);
	if ( option )
		fofs = search_dtree64(&err,
				&option->size,r,from,option->flags);
	else	fofs = search_dtree64(&err,0,r,from,1);
	if ( fofs == 0 )
		return 0;
	ret = read_filespace64(p,fofs);
	change_endian_assoc64_data(&ret->d);
	if ( ret == 0 )
		er_panic("search_assoc64_string");
	if ( ret->d.h.type != PNT_ASSOC_DATA )
		er_panic("search_assoc64_string(2)");
	return ret;
}

XL_SEXP *
search_associate64(int key,int index,void * from,void * opt)
{
ASSOC64_INDEX * ix;
STREAM * st;
ACC64_PN_ASSOC_DATA * dd;


	if ( key < 1 )
		return 0;
	if ( key >= ASSOC_KEY_NO )
		return 0;
	if ( index < 0 )
		return 0;
	if ( index >= as_key64[key].assoc_len )
		return 0;
	ix = &as_key64[key].assoc->d.ix[index];
	switch ( ix->type ) {
	case AIT_INTEGER:
		dd = search_assoc64_integer(as_key64[key].p,ix,from);
		break;
	case AIT_STRING:
		dd = search_assoc64_string(as_key64[key].p,ix,from,opt);
		break;
	default:
		er_panic("insert_associate(3)");
	}
	if ( dd == 0 )
		return 0;
	st = s_open_string_read(dd->d.data,
		search_cm(as_key64[key].fheader->d.encoding),
		strlen(dd->d.data),
		1);
	d_f_ree(dd);
	if ( st == 0 )
		er_panic("search_assoc");
	return car(init_parse(st,l_string(std_cm,"associate"),
			l_string(std_cm,"associate")));
}

typedef struct get_all_work {
	PDB64 * 		p;
	XL_SEXP *		ret;
	CODE_METHOD *		cm;
} GET_ALL_WORK;

int
get_all_integer_func64(FAVT64_NODE * a,GET_ALL_WORK * w)
{
ASSOC64_INTEGER * inp;
ACC64_PN_ASSOC_DATA * dd;
STREAM * st;
	inp = a->data;
	dd = read_filespace64(w->p,inp->fofs);
	if ( dd == 0 )
		er_panic("search_assoc_integer");
	change_endian_assoc64_data(&dd->d);
	if ( dd->d.h.type != PNT_ASSOC_DATA )
		er_panic("search_assoc_integer(2)");

	gc_push(w->ret,gc_gb_sexp,"get_all_integer");

	st = s_open_string_read(dd->d.data,
		w->cm,
		strlen(dd->d.data),
		1);
	d_f_ree(dd);
	if ( st == 0 )
		er_panic("search_assoc");
	w->ret = cons(car(init_parse(st,l_string(std_cm,"associate"),
			l_string(std_cm,"associate"))),
			w->ret);

	gc_pop(w->ret,gc_gb_sexp);

	return 0;
}

int
get_all_string_func64(int fofs,ACC64_PN_ASSOC_DATA * dd,DTREE64_TRACE_WORK * ww)
{
STREAM * st;
GET_ALL_WORK  * w;
XL_SEXP * ret;
ACC64_PN_ASSOC_DATA * ddd;

	ddd = dd;
	w = ww->w;
	if ( dd == 0 ) {
		dd = read_filespace64(w->p,fofs);
		if ( dd == 0 )
			er_panic("search_assoc_integer");
	}
	change_endian_assoc64_data(&dd->d);
	if ( dd->d.h.type != PNT_ASSOC_DATA )
		er_panic("get_all_string(2)");


	gc_push(w->ret,gc_gb_sexp,"get_all_string");

	st = s_open_string_read(dd->d.data,
		w->cm,
		strlen(dd->d.data),
		1);
	if ( st == 0 )
		er_panic("search_assoc");
	ret = cons(car(init_parse(st,l_string(std_cm,"associate"),
			l_string(std_cm,"associate"))),
			w->ret);
	w->ret = ret;

	gc_pop(w->ret,gc_gb_sexp);

	if ( ddd == 0 )
		d_f_ree(dd);

	return 0;
}



XL_SEXP *
get_assoc64_all(int key,int index)
{
ASSOC64_INDEX * ix;
GET_ALL_WORK w;
FAVT64_ROOT * r;
int err;

	if ( key < 1 )
		return 0;
	if ( key >= ASSOC_KEY_NO )
		return 0;
	if ( index < 0 )
		return 0;
	if ( index >= as_key64[key].assoc_len )
		return 0;
	ix = &as_key64[key].assoc->d.ix[index];
	w.ret = 0;
	w.cm = search_cm(as_key64[key].fheader->d.encoding),
check_cache64("assoc 1");
	r = get_root64(&err,as_key64[key].p,ix->fofs,integer_endian64);
check_cache64("assoc 2");

	switch ( ix->type ) {
	case AIT_INTEGER:
		favt64_trace_from_large(&err,r,
			root_node64(&err,r),get_all_integer_func64,&w);
		break;
	case AIT_STRING:
		dtree64_trace_from_large(&err,r,get_all_string_func64,&w);
		break;
	default:
		er_panic("get_assoc_all(3)");
	}
	return w.ret;
}
