/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"favt.h"
#include	"task.h"
#include	"filespace.h"
#include	"lock_level.h"


SEM l_favt_lock;

void
init_l_favt()
{
	init_favt();
	l_favt_lock = new_lock(LL_FAVT);
}


FAVT_NODE *
l_favt_alloc_node(FAVT_ROOT * rt,
	void * data,int data_size)
{
FAVT_NODE * ret;
	lock_task(l_favt_lock);
	ret = favt_alloc_node(rt,data,data_size);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}

FAVT_ROOT *
l_favt_alloc_root(PDB * p,int type,void (*func)())
{
FAVT_ROOT * ret;
	lock_task(l_favt_lock);
	ret = favt_alloc_root(p,type,func);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}


FAVT_NODE *
l_favt_delete(int * errp,FAVT_ROOT * p,FAVT_PTR * favtp,void * data,int (*cmp)())
{
FAVT_NODE * ret;
	lock_task(l_favt_lock);
	ret = favt_delete(errp,p,favtp,data,cmp);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}


void
l_favt_free_node(FAVT_NODE * n)
{
	lock_task(l_favt_lock);
	favt_free_node(n);
	unlock_task(l_favt_lock,"unlock");
}


FAVT_NODE *
l_favt_insert(int * errp,
	FAVT_ROOT * p,FAVT_PTR * favtp,FAVT_NODE * a,int (*cmp)())
{
FAVT_NODE * ret;
	lock_task(l_favt_lock);
	ret = favt_insert(errp,p,favtp,a,cmp);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}


FAVT_NODE *
l_favt_search(int * errp,
	FAVT_ROOT * p,FAVT_NODE * a,void * data,int (*cmp)())
{
FAVT_NODE * ret;
	lock_task(l_favt_lock);
	ret = favt_search(errp,p,a,data,cmp);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}


int
l_favt_trace_from_small(int * errp,
		FAVT_ROOT * p,FAVT_NODE * a,int (*func)(),void * work)
{
int ret;
	lock_task(l_favt_lock);
	ret = favt_trace_from_small(errp,p,a,func,work);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}

FAVT_ROOT *
l_get_root(int * errp,PDB * p,unsigned int fofs,void (*func)())
{
FAVT_ROOT * ret;
	lock_task(l_favt_lock);
	ret = get_root(errp,p,fofs,func);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}


FAVT_NODE *
l_root_node(int * errp,FAVT_ROOT * r)
{
FAVT_NODE * ret;
	lock_task(l_favt_lock);
	ret = root_node(errp,r);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}


void
l_check_cache(char * str)
{
	lock_task(l_favt_lock);
	check_cache(str);
	unlock_task(l_favt_lock,"unlock");
}


int
l_favt_trace_from_large(int * errp,
		FAVT_ROOT * p,FAVT_NODE * a,int (*func)(),void * work)
{
int ret;
	lock_task(l_favt_lock);
	ret = favt_trace_from_large(errp,p,a,func,work);
	unlock_task(l_favt_lock,"unlock");
	return ret;
}


void
l_flush_favt_cache(PDB * p)
{
	lock_task(l_favt_lock);
	flush_favt_cache(p);
	unlock_task(l_favt_lock,"unlock");
}



void
l_flush_filespace(PDB * p)
{
	lock_task(l_favt_lock);
	flush_filespace(p);
	unlock_task(l_favt_lock,"unlock");
}


void
l_close_filespace(PDB * p)
{
	lock_task(l_favt_lock);
	close_filespace(p);
	unlock_task(l_favt_lock,"unlock");
}

