/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_OCEANSEA_BOUNDARY_AFT_H____
#define GM_OCEANSEA_BOUNDARY_AFT_H____

#include "vpf_types.h" 
#include "vpf_container.h"
#include "vpf_table.h"

typedef struct {
	LONG id;
	char f_code[6];
	char soc[4];
	SHORT tile_id;
	LONG fac_id;
}GM_OCEANSEA_AFT_RECORD;

void gm_oceansea_aft_delete(GM_OCEANSEA_AFT_RECORD *record);
BOOL gm_oceansea_aft_read(VPF_TABLE *table, FILE *fp, VPF_LIST *cols_info);
LONG gm_oceansea_aft_get_tileid(const GM_OCEANSEA_AFT_RECORD *record);
LONG gm_oceansea_aft_get_fac_id(const GM_OCEANSEA_AFT_RECORD *record);
void gm_oceansea_aft_write_information_tag(FILE *fp, GM_OCEANSEA_AFT_RECORD *record);

#endif

