/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	<stdlib.h>
#include	"long_char.h"
#include	"memory_routine.h"
#include	"xl.h"
#include	"xl.h"
#include	"utils.h"
#include	"xl2pdb_p.h"


extern PDB_POLYGON2D * pdb_p_list;
extern L_CHAR * unitname;
extern PDB_PT * pdb_pt;
extern double max_resolution;
extern int lod_max,lod_min;
GB_RECT minrect;

//nakajima@zeta 2001.04.12
extern int point_nos;

int
main(int argc,char ** argv)
{
XLISP_ENV * env;
XL_INTERPRETER * xli;
int id;

	init_xl();

	if ( argc < 2 ) {
		fprintf(stderr,"too few argments\n");
		exit(1);
	}

	unitname = nl_copy_str(std_cm,"m");
	minrect.tl.x = minrect.tl.y = 0;
	minrect.br.x = minrect.br.y = -1;

	init_function(gblisp_top_env0,gblisp_top_env1,argc,argv);
	init_x2p_function(gblisp_top_env0,gblisp_top_env1);

	//nakajima@zeta 2001.04.12
	point_nos = 0;
/*
XL_INTERPRETER * xli;
int id;

	init_xl();

	if ( argc < 2 ) {
		fprintf(stderr,"too few argments\n");
		exit(1);
	}

	unitname = nl_copy_str(std_cm,"m");
	minrect.tl.x = minrect.tl.y = 0;
	minrect.br.x = minrect.br.y = -1;

	init_function(gblisp_top_env0,gblisp_top_env1,argc,argv);
	init_x2p_function(gblisp_top_env0,gblisp_top_env1);

	fprintf(stderr,"LOADING FILE...\n");
	env = new_env(gblisp_top_env1);
	xli = new_xl_interpreter();
	xli->a_type = XLA_FILE;
	xli->env = env;
	xli->input_file_name = nl_copy_str(std_cm,argv[1]);
	if ( argc >= 3 ) {
		if ( strcmp(argv[2],"/") == 0 )
			goto next;
		xli->output_file_name = nl_copy_str(std_cm,argv[2]);
	}
	if ( argc >= 4 ) {
		if ( strcmp(argv[3],"/") == 0 )
			goto next;
		xli->error_file_name = nl_copy_str(std_cm,argv[3]);
	}
next:
	xli->environment = 0;
	id = setup_i(xli);
	if ( id < 0 ) {
		fprintf(stderr,"cannot open shell argument %s\n",
			argv[1]);
		exit(1);
	}
	wait_stop_all();
*/
	fprintf(stderr,"LOADING FILE...\n");
	//nakajima@zeta 2001.04.12
	load_svg(argc,argv);
	
	fprintf(stderr,"\nNUMMBERING...\n");
	numbering();
	fprintf(stderr,"INFORMATION...\n");
	output_info(argc,argv);

	fprintf(stderr,"LOD CONTROL...\n");
	lod_control();

	fprintf(stderr,"MAKING TREE...\n");
	make_tree();
	fprintf(stderr,"SAVE PDB FILE...\n");
	save_pdb(argc,argv);
	fprintf(stderr,"END\n");
	fprintf(stderr,"\tminrect = (%f %f)-(%f %f)\n",
		minrect.tl.x,
		minrect.tl.y,
		minrect.br.x,
		minrect.br.y);
	fprintf(stderr,"lod %i-%i\n",lod_min,lod_max);
	fprintf(stderr,"resolution = %lf\n",1/max_resolution);
	return 0;
}

