/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include "machine/include.h"
#include <fcntl.h>
#include <stdlib.h>
#include "ppm_types.h"
#include "ppmlib_types.h"
#include "u_file.h"

void
write_pixel(PPM_INFO * p,unsigned int w,unsigned int h,unsigned char * c)
{
INTEGER64 ofs,i,ofs2;
unsigned char * data;
unsigned char * cc;
	data = get_pixel(p,w,h);
	if ( data ) {
		cc = c;
		for ( i = 0 ; i < 3 ; i ++ )
			*data ++ = *cc ++;
	}
	ofs = LINE_HEAD(p,h);
	if ( p->pi_write_offset != ofs ) {
		if ( p->pi_write ) {
			u_lseek64(p->pi_fd,ofs,SEEK_SET);
			u_write(p->pi_fd,p->pi_write,p->pi_width*3);
			free(p->pi_write);
		}
		p->pi_write = malloc(p->pi_width*3);
		ofs2 = u_lseek64(p->pi_fd,ofs,SEEK_SET);
		if ( ofs2 == ofs ) {
			u_read(p->pi_fd,p->pi_write,p->pi_width*3);
		}
		p->pi_write_offset = ofs;
	}
	data = &p->pi_write[w*3];
	for ( i = 0 ; i < 3 ; i ++ )
		*data ++ = *c ++;
}

