/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include <stdlib.h>
#include <limits.h>
#include "v/VBackColorView.h"
#include "v/vobj_utils.h"

extern "C" {
#include "xl.h"
#include "xlerror.h"

XL_SEXP *
vobj_VBackColorView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf);


XL_SEXP *
vobj_VBackColorView(XLISP_ENV *env, XL_SEXP *arg, XLISP_ENV *a, XL_SYM_FIELD *sf)
{
XL_SEXP * _ref;
VObjectStatus sts;
VBackColorView * obj;
int flags = 0;

	L_CHAR *attr;
	if ( ( attr = get_sf_attribute(sf, l_string(std_cm, "color")) ) ) {
		flags |= VSF_ATTR;
		if ( l_strcmp(attr, l_string(std_cm, "none")) == 0 )
			SET_RGB8_32(sts.attr,0,0,0,0)
		else {
			char buf[3];
			unsigned char c[3];
			if ( l_strlen(attr) == 7 && attr[0] == '#' ) {
				buf[2] = 0;
				for ( int i = 0 ; i < 3 ; i++ ) {
					buf[0] = attr[i*2+1];
					buf[1] = attr[i*2+2];
					c[i] = strtol(buf, NULL, 16);
				}
				SET_RGB8_32(sts.attr,c[0],c[1],c[2],0xff);
			}
			else {
				return get_error(
					arg->h.file,
					arg->h.line,
					XLE_PROTO_INV_PARAM,
					l_string(std_cm,"VBackColorView"),
					n_get_string("invalid color format"));
			}
		}
	}
	
	_ref = get_refered_object<VBackColorView>
			(&obj,env,arg,sf,VO_BGCV,"VBackColorView",&sts,flags,0);
	if ( get_type(_ref) == XLT_ERROR )
		return _ref;

	obj->get_status(&sts,VSF_ID);
	XL_SEXP *ret = vobj_eval_child(sts.id, env, arg);
	if ( get_type(ret) == XLT_ERROR )
		return ret;
	if ( get_type(_ref) == XLT_INTEGER )
		return vobj_get_id_list(_ref->integer.data, ret, sf, 0);
	else	return vobj_get_id_list(sts.id, ret, sf,0);
}

void
init_VBackColorView(XLISP_ENV *env)
{
	set_env(env,l_string(std_cm,"VBackColorView"),
		get_func_prim((XL_SEXP*(*)())vobj_VBackColorView,FO_NORMAL,0,1,2));
}


} // extern "C"
