/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_Break();


void
init_Break(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Break"),
		get_func_prim(xl_Break,FO_APPLICATIVE,0,1,2));
}

XL_SEXP *
xl_Break(XLISP_ENV * env,XL_SEXP * s)
{
	if ( list_length(s) == 2 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SYSTEM_LOOP_BREAK,
			l_string(std_cm,"Break"),
			get_el(s,1));
	else
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SYSTEM_LOOP_BREAK,
			l_string(std_cm,"Break"),
			0);
}


