/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/




#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_GetMainInterpreter();

void
init_GetMainInterpreter(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"GetMainInterpreter"),
		get_func_prim(xl_GetMainInterpreter,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_GetMainInterpreter(XLISP_ENV * env,XL_SEXP * s)
{
int ret;
	ret = get_main_interpreter();
	if ( ret < 0 )
		return get_error(
			s->h.file,
			s->h.line,
			XLE_PROTO_UNDEF_RESOURCE,
			l_string(std_cm,"GetMainInterpreter"),
			n_get_string("undefined main interpreter"));
	else	return get_integer(ret,0);
}

