/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"


XL_SEXP * xl_Sleep();

void
init_Sleep(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"Sleep"),
		get_func_prim(xl_Sleep,FO_APPLICATIVE,0,2,2));
}

void gc_gb_sexp();

XL_SEXP *
xl_Sleep(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * time;
int _time;
int er;
XL_SEXP * r;
	time = get_el(s,1);
	switch ( get_type(time) ) {
	case XLT_ERROR:
		return time;
	case XLT_INTEGER:
		_time = conv_unit(&er,
				get_uenv(env),
				time->integer.data,
				time->integer.unit,
				l_string(std_cm,"sec"));
		break;
	case XLT_FLOAT:
		_time = conv_unit(&er,
				get_uenv(env),
				time->floating.data,
				time->floating.unit,
				l_string(std_cm,"sec"));
		break;
	default:
		goto type_missmatch;
	}
	for ( ; _time > 0 ; _time -- ) {
		gc_push(0,0,"Sleep");
		r = do_break_check(s);
		if ( get_type(r) == XLT_ERROR ) {
			gc_pop(r,gc_gb_sexp);
			return r;
		}
		gc_pop(0,0);
		sleep_sec(1);
	}
	return time;
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"Sleep"),
		0);
/*
internal_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SYSTEM_INTERNAL,
		l_string(std_cm,"Sleep"),
		n_get_string("shell arguments initializing is required"));
*/
}


