/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"
#include	"xlerror.h"


XL_SEXP * 
gb_wait(XLISP_ENV * env,XL_SEXP * s)
{
XL_SEXP * slp;
	slp = eval(env,get_el(s,1));
	switch ( get_type(slp) ) {
	case XLT_ERROR:
		return slp;
	case XLT_INTEGER:
		sleep_sec(slp->integer.data);
		return 0;
	default:
		return get_error(
			s->h.file,
			s->h.line,
			XLE_SEMANTICS_TYPE_MISSMATCH,
			l_string(std_cm,"wait"),
			list(	n_get_string("typemissmatch"),
				0));
	}
}
