#include <ft2build.h>
#include FT_FREETYPE_H

int ft_error_code;
#define FT_ASSERT(a)	ft_error_code = a; do if ( ft_error_code ) { printf("FreeType2 Error: %s  [Code = %d]\n", #a, ft_error_code); exit(1); } while ( 0 )

int
main(int argc, char* argv[])
{
	FT_Library library;
	FT_Face face;
	FT_GlyphSlot slot;
	int glyph_index;
	int char_code = 'c';
	int x, y, w, h;
	
	if ( argc < 2 ) {
		fprintf(stderr, "usage %s <font file>\n", argv[0]);
		exit(1);
	}
	FT_ASSERT( FT_Init_FreeType(&library) );
	FT_ASSERT( FT_New_Face(library,
		argv[1],
		0,
		&face) );
	printf("includes %d faces\n", face->num_faces);
	
	FT_ASSERT( FT_Set_Char_Size(
		face,    /* handle to face object           */
		0,       /* char_width in 1/64th of points  */
		32*64,   /* char_height in 1/64th of points */
		72,     /* horizontal device resolution    */
		72) );   /* vertical device resolution      */
	
	
	printf("char_code   : %x\n", char_code);
	glyph_index = FT_Get_Char_Index(face, char_code);
	printf("glyph_index : %x\n", glyph_index);
	FT_ASSERT( FT_Load_Glyph(face, glyph_index, FT_LOAD_DEFAULT) );
	slot = face->glyph;
	FT_ASSERT( FT_Render_Glyph(slot, ft_render_mode_normal) );
	printf("pos  : %d x %d\n", slot->bitmap_left, slot->bitmap_top);
	w = slot->bitmap.width;
	h = slot->bitmap.rows;
	printf("size : %d x %d\n", w, h);
	printf("advance : %d\n", slot->advance.x>>6);
	if ( FT_HAS_KERNING(face) ) {
		printf("karning info :\n");
		FT_Vector  delta;
		FT_Get_Kerning(face, 'A', glyph_index, 0, &delta);
		printf("    delta for 'A' : %d\n", delta.x >> 6);
		FT_Get_Kerning(face, 'V', glyph_index, 0, &delta);
		printf("    delta for 'V' : %d\n", delta.x >> 6);
	}
	printf("\n");
	for ( y = 0 ; y < h ; y++ ) {
//		for ( x = 0 ; x < w ; x++ )
//			printf("%3d ", slot->bitmap.buffer[x+w*y]);
//		printf("   ");
		for ( x = 0 ; x < w ; x++ )
			printf(slot->bitmap.buffer[x+w*y] > 90? "[]" : "  ");
		printf("\n");
	}
	return 0;
}