/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VAlignView.h"
#include "LView.h"

//extern "C" void er_panic(char*);
VInfo* make_LView(const VObjectStatus *s, VObject* obj,VInfo * p_info);

VInfo*
make_LView(const VObjectStatus *s, VObject* obj,VInfo * p_info)
{
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(p_info);
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = s->id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)obj;
	SViewInfo viewInfo = { (SDimension32){0,0}, {0,0}, {1,1}, false };
	lock_task(app_lock);
	LView *v = new LView(paneInfo, viewInfo);
	//v->AddAttachment(new LBorderAttachment);
	v->FinishCreate();
	unlock_task(app_lock,"");
	return v;
}



void
VAlignView::destroy_do(VObject* nmp)
{
	nmp->remove_child_do(this);
	lock_task(app_lock);
	delete info;
	unlock_task(app_lock,"");
	nmp->redraw();
}

VAlignView::~VAlignView()
{
}

VExError
VAlignView::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = v_get_status_standard(s, &flags, info);
	VExError err2 = VObject::get_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);
	V_OP_END
	return err;
};

VExError
VAlignView::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = v_set_status_standard(s, flags, &sts, info);
	VExError err2 = VObject::set_status(s,flags);
	if ( err2.code )
		err = merge_VExError_vstatus_type(err,err2);

	if ( flags & VSF_CALC_MIN ) {
		for ( VObjectList *list = sts.children ; list ; list = list->next )
			list->object->set_status(0, VSF_CALC_MIN);
		VLayout layout;
		layout.layout_in_align_view(this, get_type()==VVAlignView::object_type, true);
		sts.min_size = layout.parent_min_size();
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	if ( flags & VSF_LAYOUT ) {
		VLayout layout;
		layout.layout_in_align_view(this, get_type()==VVAlignView::object_type);
		layout.do_layout(this);
		err.subcode1 &= ~VSF_LAYOUT;
	}

	V_OP_END

	if ( flags & (VSF_HOMOGEN | VSF_SPACING | VSF_ALIGN | VSF_PADDING | VSF_VISIBLE ) )
		VLayout::mark(this);

	return err;
}

VExError
VAlignView::add_child_do(VObject*child)
{
	return initial_VExError(V_ER_NO_ERR,0,0);
}

void
VAlignView::remove_child_do(VObject* child)
{
	// do nothing
}

VExError
VAlignView::reorder_child(VObject* child, int order)
{
	VObjectList *c, *p = 0, *k;
	int i = 0;
	for ( c = sts.children ; c && c->object != child ; p = c, c = c->next ) { i++; }
	VExError err = initial_VExError(V_ER_NO_ERR, 0, 0);
	V_OP_START_EX
	if ( c == 0 )
		return initial_VExError(V_ER_NOT_FOUND, 0, 0);
	if ( i == order )
		return initial_VExError(V_ER_NO_ERR, 0, 0);
	p->next = c->next;
	k = c;
	
	i = 0;
	p = 0;
	c = sts.children;
	while ( i++ != order && c ) {
			p = c;
			c = c->next;
	}
	if ( p ) {
		k->next = p->next;
		p->next = k;
	}
	else {
		k->next = sts.children;
		sts.children = k;
	}
	V_OP_END
	VLayout::mark(this);
	return err;
}

void
VAlignView::child_status_changed(VObject* child, VInfo* info)
{
	// do nothing - object is marked when status is changed
}

void
VAlignView::redraw(VRect* rect) const
{
	_V_OP_START()
	lock_task(app_lock);
	if ( rect )
		info->RefreshRect((Rect){rect->t, rect->l, rect->b, rect->r});
	else
		info->Refresh();
	unlock_task(app_lock,"");
	V_OP_END
}

VExError
VHAlignView::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	info = make_LView(s,this,nmp->get_info_this());
	return nmp->add_child_do(this);
}

VExError
VVAlignView::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	info = make_LView(s,this,nmp->get_info_this());
	return nmp->add_child_do(this);
}
