/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "PP_Prefix.h"
#include "UStandardDialogs.h"

#include	"LDocument.h"
#include	"v/VChooseFile.h"

extern "C" {
#include	"utils.h"
#include	"memory_debug.h"
#include	"machine/v_m.h"
char * get_path_from_mac_fs(FSSpec inMacFSSpec, Boolean isFolder);
char * mac_string(LC_FONT * f,const L_CHAR * _str);

typedef struct __v_choose_file_t {
	PP_StandardDialogs::LFileChooser *	chooser;
	bool				ret;
} __V_CHOOSE_FILE_T;

void
_v_choose_file(void * arg)
{
__V_CHOOSE_FILE_T * t;
	t = (__V_CHOOSE_FILE_T*)arg;
	t->ret = t->chooser->AskOpenFile(LFileTypeList(fileTypes_All));
}


char *
v_choose_file(const L_CHAR *title, const char *default_path)
{
__V_CHOOSE_FILE_T ret;
	PP_StandardDialogs::LFileChooser	chooser;
	FSSpec spec;

	lock_task(app_lock);
	NavDialogOptions*	options = chooser.GetDialogOptions();
	unlock_task(app_lock,"");
	if (options != nil) {
		options->dialogOptionFlags =	kNavDefaultNavDlogOptions
										+ kNavSelectAllReadableItem;
		c2pstrcpy(options->windowTitle, title ? mac_string(0,title) : "");
	}

	if ( default_path ) {
		char * def = change_delim_str(default_path);
		StringPtr d = (StringPtr)d_alloc((strlen(def)+1));
		c2pstrcpy(d, def);
		lock_task(app_lock);
		if ( noErr == FSMakeFSSpec(0, 0, d, &spec) )
			chooser.SetDefaultLocation(spec, true);
		unlock_task(app_lock,"");
		d_f_ree(d);
		d_f_ree(def);
	}
/*
	if (chooser.AskOpenFile(LFileTypeList(fileTypes_All))) {
*/
	ret.chooser = &chooser;
	ret.ret = false;
	lthread_do(_v_choose_file,(void*)&ret,1,0);
	if ( ret.ret ) {
		lock_task(app_lock);
		chooser.GetFileSpec(1, spec);
		unlock_task(app_lock,"");
		char * path = get_path_from_mac_fs(spec, false);
		char *ret = normalize_delim_str(path);
		d_f_ree(path);
		return ret;
	}
	return 0;
}



typedef struct __v_save_as_file_t {
	StringPtr			name;
	PP_StandardDialogs::LFileDesignator *		designator;
	bool				ret;
} __V_SAVE_AS_FILE_T;

void
_v_save_as_file(void * arg)
{
__V_SAVE_AS_FILE_T * t;
	t = (__V_SAVE_AS_FILE_T*)arg;
	t->ret = t->designator->AskDesignateFile(t->name ? t->name : "\p");
}


char *
v_save_as_file(const L_CHAR *title, const char *default_path)
{
__V_SAVE_AS_FILE_T ret;
	PP_StandardDialogs::LFileDesignator		designator;
	StringPtr name = 0;
	FSRef ref;
	FSSpec spec;
	lock_task(app_lock);
	NavDialogOptions*	options = designator.GetDialogOptions();
	unlock_task(app_lock,"");
	if (options != nil) {
		c2pstrcpy(options->windowTitle, title ? mac_string(0,title) : "");
	}
	
	if ( default_path ) {
		char * def = change_delim_str(default_path);
		char *last_delim = def-1;
		for ( char *s = def; *s; s++ ) {
			if (*s == '/')
				last_delim = s;
		}
		if (last_delim != def-1)
			*last_delim = 0;
		last_delim++;
		
		Boolean dir = true;
		lock_task(app_lock);
		if ( noErr == FSPathMakeRef((UInt8*)def, &ref, &dir) &&
			 noErr == FSGetCatalogInfo(&ref, kFSCatInfoNone, 0, 0, &spec, 0) )
			designator.SetDefaultLocation(spec, true);
		unlock_task(app_lock,"");
		name = (StringPtr)d_alloc((strlen(last_delim)+1));
		c2pstrcpy(name, last_delim);

		d_f_ree(def);
	}
/*
	bool	askOK = designator.AskDesignateFile(name ? name : "\p");
*/
	bool	askOK;

	ret.name = name;
	ret.designator = &designator;
	ret.ret = false;

	lthread_do(_v_save_as_file,(void*)&ret,1,0);
	askOK = ret.ret;

	if (name)
		d_f_ree(name);

	if (askOK) {
		designator.GetFileSpec(spec);
		int name_len = spec.name[0];
		spec.name[0] = 0;	// spec of directory
		char * path = get_path_from_mac_fs(spec, true); // get directory path
		int len = strlen(path);
		path = (char*)d_re_alloc(path, len+name_len+1);
		spec.name[0] = name_len;						// revert to file spec
		p2cstrcpy(path+len, spec.name);					// marge file name
		char *ret = normalize_delim_str(path);
		d_f_ree(path);
		return ret;
	}
	return 0;
}

}
