/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VButton.h"
#include "VReflector.h"
#include "CClickCheckAttachment.h"
#include "LView.h"
#include "UEnvironment.h"
#include "LPushButton.h"

void AddDefaultButton(LPane *pane, LPushButton *button);
void RemoveDefaultButton(LPane *pane, LPushButton *button);
void AddCancelButton(LPane *pane, LPushButton *button);
void RemoveCancelButton(LPane *pane, LPushButton *button);


VExError
VPushButton::create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg)
{
	SPaneInfo paneInfo;
	paneInfo.superView = dynamic_cast<LView*>(nmp->get_info_this());
	if ( paneInfo.superView == 0 )
		er_panic("non-LView object cannot be parent");
	paneInfo.paneID = sts.id;
	paneInfo.width = 0;
	paneInfo.height = 0;
	paneInfo.visible = true;
	paneInfo.enabled = true;
	paneInfo.left = 0;
	paneInfo.top = 0;
	paneInfo.bindings = (SBooleanRect){false,false,false,false};
	paneInfo.userCon = (long)this;
	lock_task(app_lock);
	LPushButton *v = new LPushButton(paneInfo, msg_ValueChanged, "\p");
	v->AddAttachment(new CClickCheckAttachment);
	v->FinishCreate();
	v->AddListener(new VReflector(this));
	info = v;
	unlock_task(app_lock,"");
	return nmp->add_child_do(this);
}

void
VPushButton::destroy_do(VObject* nmp)
{
	lock_task(app_lock);
	LPane *win = sts.window->get_info_this()->GetSuperView();
	if ( sts.attr & default_button )
		RemoveDefaultButton(win, (LPushButton*)info);
	if ( sts.attr & cancel_button )
		RemoveCancelButton(win, (LPushButton*)info);
	unlock_task(app_lock,"");
	VButton::destroy_do(nmp);
}

VPushButton::~VPushButton()
{
}


VExError
VPushButton::get_status(VObjectStatus *s, int flags) const
{
	VExError er = VButton::get_status(s,flags);
	if ( flags & VSF_SIZE ) {
		if ( UEnvironment::IsRunningOSX() )
			s->size.w += 7;
			s->size.h += 2;
	}
	return er;
};

VExError
VPushButton::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = VButton::set_status(s,flags&~VSF_SIZE);
	LPushButton *btn = (LPushButton*)info;
	lock_task(app_lock);
	LPane *win = sts.window->get_info_this()->GetSuperView();
	unlock_task(app_lock,"");

	if ( flags & VSF_SIZE ) {
		if ( s->size.w != sts.size.w || s->size.h != sts.size.h ) {
			lock_task(app_lock);
			info->ResizeFrameTo(s->size.w-(UEnvironment::IsRunningOSX()?7:0), s->size.h-(UEnvironment::IsRunningOSX()?2:0), true);
			unlock_task(app_lock,"");
		}
	}

	if ( flags & (VSF_DESC | VSF_VERTD | VSF_FSIZE | VSF_WS) ) {
		lock_task(app_lock);
		if ( UEnvironment::IsRunningOSX() ) {
			// enlarge button to display descriptor correctly on OS X
			sts.min_size.w += 7;
			sts.min_size.h += 2;
		}
		unlock_task(app_lock,"");
	}

	if ( flags & VSF_ATTR ) {
		lock_task(app_lock);
		if ( s->attr & default_button ) {
			btn->SetDefaultButton(true);
			AddDefaultButton(win, btn);
		}
		else {
			btn->SetDefaultButton(false);
			RemoveDefaultButton(win, btn);
		}
		
		if ( s->attr & cancel_button ) {
			AddCancelButton(win, btn);
		}
		else {
			RemoveCancelButton(win, btn);
		}
		unlock_task(app_lock,"");
	}

	V_OP_END
	
	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_DESC | VSF_VERTD | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}
