/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


// ===========================================================================
//	VApplication.h
// ===========================================================================

#ifndef _H_VApplication
#define _H_VApplication
#pragma once

#include <LApplication.h>
#include <LDocApplication.h>
#include "v/v.h"
#include	"LSimpleThread.h"

typedef struct lthread_data {
	struct lthread_data *	next;
	void *		arg;
	void		(*func)(void *arg);
	unsigned	end_flag:1;
	unsigned	wait_flag:1;
} LTHREAD_DATA;


class VApplication : public LDocApplication {

public:
						VApplication();
	virtual					~VApplication();

	virtual Boolean			ObeyCommand(
								CommandT			inCommand,
								void*				ioParam = nil);	

	virtual void			FindCommandStatus(
								CommandT			inCommand,
								Boolean&			outEnabled,
								Boolean&			outUsesMark,
								UInt16&				outMark,
								Str255				outName);

	virtual void			OpenDocument(
								FSSpec*				inMacFSSpec);
	virtual void			ChooseDocument();

	static void intermediate_run_thread(LThread &,void*);

	void xx_vq_insert_callback_inner(
			VObject *object,
			V_CALLBACK(handler),
			void *usr_arg,
			void *sys_arg,
			int sys_arg_size,
			char * sequence_key,
			int *inherit,
			char * __f,
			int __l);
	void				_thread_init();
	int				_inMain();
	
	void insert_lthread(LTHREAD_DATA * ld,int);

protected:


	void _intermediate_run_thread();
	void StartUp2();
	VQueEventHandler *		vq_inherit;
	int *				vq_inherit_point;
	VQueEventHandler *		vq_head;
	VQueEventHandler *		vq_tail;
	VQueEventHandler *
		vq_delete_callback_inner();
	void free_VQueEventHandler(VQueEventHandler*);
	void relay_que();
	void relay_que_inherit();


	LTHREAD_DATA *			ld_head;
	LTHREAD_DATA *			ld_tail;
	LTHREAD_DATA *			ldr_head;
	LTHREAD_DATA *			ldr_tail;
	
	static void lthread_grue(LThread &thread,void * data);
	void lthread_run();

	virtual void			StartUp();
	virtual	void			DoReopenApp();
	virtual void			DoPreferences();	
	void				RegisterClasses();

	virtual Boolean			AttemptQuitSelf( SInt32	 inSaveOption );
	
	unsigned int			top_of_main;
	unsigned int			bottom_of_main;
	
	static void tick_loop();
	void lthread_routine();

};

extern VApplication *theApp;
extern int appBusyLv;


#endif // _H_VApplication
