/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


// ===========================================================================
//	VLayout.h
// ===========================================================================

#ifndef _H_VLayoutAttachment
#define _H_VLayoutAttachment
#pragma once

#include <LApplication.h>
#include <LPeriodical.h>

#include "v/VLayout.h"

extern "C" {
#include	"task.h"
}
extern SEM tick_lock;

class VLayoutAttachment : public LAttachment, public LPeriodical
{
protected:
	// called before event is dispatched
	static V_CALLBACK_D(_ExecuteSelf)
			{
				if ( VLayout::need_layout() )
					VLayout::layout_marked_window();
			}
/*
	virtual void	ExecuteSelf(
					MessageT	inMessage,
					void*		ioParam)
			{
				if ( VLayout::need_layout() )
					VLayout::layout_marked_window();
				mExecuteHost = true;
			}
*/
	virtual void	ExecuteSelf(
					MessageT	inMessage,
					void*		ioParam)
			{
				mExecuteHost = true;
/*
				if ( tick_lock.so )
					new_tick(_ExecuteSelf,0,0);
*/
				vq_insert_callback_machine(0,_ExecuteSelf,0,0,0,0,0);
			}
public:
	// called after event is dipatched
	static V_CALLBACK_D(_SpendTime)
			{
				if ( VLayout::need_layout() )
					VLayout::layout_marked_window();
			}
	virtual	void	SpendTime( const EventRecord& inMacEvent )
			{
/*
				if ( VLayout::need_layout() )
					VLayout::layout_marked_window();
*/
				vq_insert_callback_machine(0,_SpendTime,0,0,0,0,0);
			}

			VLayoutAttachment()
			{
				StartRepeating();
			}
};


#endif // _H_VLayoutAttachment