/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdio.h>
#include	<stdlib.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"machine/v_types.h"
#include	"long_char.h"

//void v_get_font();

LC_FONT_ENGINE_TYPE mac_font_engine_type = {
        "QuickDraw",
        v_get_font,
        v_get_string_pic,
        0,
        {0,0},
        0
};


VDISPLAY * disp_list = nil;


void
v_set_display_key(char * key)
{
}

int
set_gb2m(unsigned int * table)
{
int i;
	for ( i = 0;  i < (1<<COL_BIT);  i++ )
		table[i] = i;
	return 0;
}

void
set_gb2m_mask_and_shift(V_MAP_TBL * tbl, short color_bit)
{
	switch (color_bit) {
	
	case 32 :
		tbl->pixel_bits = 32;
		tbl->red_shift = 16;
		tbl->green_shift = 8;
		tbl->blue_shift = 0;
		tbl->color_bit = 8;
		tbl->red_mask = 0xff0000;
		tbl->green_mask = 0xff00;
		tbl->blue_mask = 0xff;
		break;

	case 16 :
		tbl->pixel_bits = 16;
		goto set16;		

	default :
		tbl->pixel_bits = 0;
set16:
		tbl->red_shift = 10;
		tbl->green_shift = 5;
		tbl->blue_shift = 0;
		tbl->color_bit = 5;
		tbl->red_mask = 0x7c00;
		tbl->green_mask = 0x3e0;
		tbl->blue_mask = 0x1f;
		break;
	}
}


VDISPLAY *
v_open_disp(VERROR * err)
{
VDISPLAY * d;
	d = d_alloc(sizeof(*d));
	d->next = disp_list;
	disp_list = d;
	
	d->fe.work = (void*)d;
	d->fe.type = &mac_font_engine_type;
	d->fe.name = "Main";
	insert_font_engine(&d->fe);

	err->err1 = E_OK;
	return d;
}
