/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include "v/VButton.h"
#include "machine/v_object.h"


VExError
VRadioButton::create_do(const VObjectStatus* s, int flags,
		VObject * nmp, void * arg)
{

	init_group_list();

	info = v_serialized_exec_func<GtkWidget*,GSList*>(
		gtk_radio_button_new_with_label, NULL, "");
	v_serialized_exec_sub(g_object_ref, info);
	VIA_MS_G_SIGNAL_CONNECT(info, "toggled", ::value_changed, this);

	return return_create_do(this,nmp,&sts,s,flags);
}

void
VRadioButton::destroy_do(VObject * nmp)
{
	delete_group_list();
	return VButton::destroy_do(nmp);
}

VRadioButton::~VRadioButton()
{
}

VExError
VRadioButton::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	
	if ( flags & VSF_VALUE ) {
		s->value = v_serialized_exec_func(gtk_toggle_button_get_active, GTK_TOGGLE_BUTTON(info));
		flags &= ~VSF_VALUE;
	}
	
	VExError err = merge_VExError_vstatus_type(
		initial_VExError(V_ER_NO_ERR,flags,0),
		VButton::get_status(s,flags));
	V_OP_END
	return err;
};


VExError
VRadioButton::set_status(const VObjectStatus *s, int flags)
{
	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(gtk_toggle_button_set_active,
			GTK_TOGGLE_BUTTON(info), s->value);
	}
	return  merge_VExError_vstatus_type(
		initial_VExError(V_ER_NO_ERR,flags & (~VSF_VALUE),0),
		VButton::set_status(s,flags));
}

void
VRadioButton::set_radio_group(VRadioButton* group)
{
	_V_OP_START_VOID
	v_serialized_exec_sub(gtk_radio_button_set_group,
		GTK_RADIO_BUTTON(info), group->get_radio_group());
	insert_group_list(group);
	V_OP_END
}

VRadioGroupInfo
VRadioButton::get_radio_group()
{
	return v_serialized_exec_func(gtk_radio_button_get_group, GTK_RADIO_BUTTON(info));
}
