/**********************************************************************

	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomohito Nakajima <nakajima@zeta.co.jp>
	Tomoki Sekiyama <sekiyama@yahoo.co.jp>

	This program is free software; you can redistribute it
	and/or modify it under the terms of the GLOBALBASE
	Library General Public License (G-LGPL) as published by

	http://www.globalbase.org/

	This program is distributed in the hope that it will be
	useful, but WITHOUT ANY WARRANTY; without even the
	implied warranty of MERCHANTABILITY or FITNESS FOR A
	PARTICULAR PURPOSE.

**********************************************************************/


#include "v/VProgressBar.h"
#include "VApplication.h"
#include "vobject_main.h"
#include "vwin_control.h"


static HWND CreateProgressWindow(int style, HWND hwnd, int id){
	return ::CreateWindowEx(
		0, 
		PROGRESS_CLASS,
		"",
		style,
		0,
		0,
		0,
		0,
		hwnd,
		(HMENU)id,
		theApp->get_instance(),
		NULL);
}

VExError 
VProgressBar::create_do(const VObjectStatus* s, int flags, VObject *parent, void * arg)
{
	
	DWORD style=WS_CHILD;
	if(!s->enabled){
		style |= WS_DISABLED;
	}
	if(s->visible){
		style |= WS_VISIBLE;
	}
	
	/* find container window that will own this button.*/
	VContainerInfo *container_info = VInfo::get_container_info(parent);
	int id = container_info->get_next_control_id();
	HWND hwnd = v_serialized_exec_func(CreateProgressWindow, style, container_info->get_hwnd(), id);
	info = new VInfo(this, hwnd, id);
	
	sts.min_size.w = 100;
	sts.min_size.h = 16;

	return parent->add_child_do(this);
}

void
VProgressBar::destroy_do(VObject *parent)
{
	parent->remove_child_do(this);
	if(info){
		v_serialized_exec_sub(::DestroyWindow, info->get_hwnd());
		delete info;
		info = NULL;
	}
	sts.parent->redraw();
}

VProgressBar::~VProgressBar()
{
}

VExError
VProgressBar::get_status(VObjectStatus *s, int flags) const
{
	V_OP_START_EX
	VExError err = VObject::get_status(s,flags);
	win_control_default_get_status(info->get_hwnd(), s, flags, &err);
	V_OP_END
	return err;
};

void
v_progress_bar_set_value(HWND hwnd, int v)
{
	DWORD style;
	if ( v < 0 || v > 100 ) {
		style = GetWindowLong(hwnd, GWL_STYLE);
		style |= 0x08/*PBS_MARQUEE*/;
		SetWindowLong(hwnd, GWL_STYLE, style);
		SendMessage(hwnd, WM_USER+10/*PBM_SETMARQUEE*/, 1, 50);
		SendMessage(hwnd, PBM_SETPOS, 0, 0);
	}
	else {
		style = GetWindowLong(hwnd, GWL_STYLE);
		style &= ~0x08/*PBS_MARQUEE*/;
		SetWindowLong(hwnd, GWL_STYLE, style);
		SendMessage(hwnd, PBM_SETPOS, v, 0);
	}
}

VExError
VProgressBar::set_status(const VObjectStatus *s, int flags)
{
	V_OP_START_EX
	VExError err = VObject::set_status(s,flags);
	HWND hwnd = info->get_hwnd();
	win_control_default_set_status(hwnd, s, flags&~VSF_DESC, &err);
	
	if ( flags & VSF_VALUE ) {
		v_serialized_exec_sub(v_progress_bar_set_value, info->get_hwnd(), s->value);
		err.subcode1 &= ~VSF_VALUE;
	}

	if ( flags & VSF_CALC_MIN ) {
		// min is set on create
		err.subcode1 &= ~VSF_CALC_MIN;
	}
	
	if ( flags & VSF_VISIBLE ) {
		if ( s->visible != (::IsWindowVisible(info->get_hwnd())==TRUE) ){
			v_serialized_exec_sub(::ShowWindow, hwnd, s->visible ? SW_SHOW : SW_HIDE);
		}
		err.subcode1 &= ~VSF_VISIBLE;
	}

	V_OP_END
	
	if ( flags & (VSF_ALIGN | VSF_PADDING | VSF_VISIBLE) )
		VLayout::mark(this);
	return err;
}

void
VProgressBar::redraw(VRect *rect) const
{
	if ( ! info )
		return;
	_V_OP_START_VOID
	win_redraw(info->get_hwnd(), rect);
	V_OP_END
}
