/**********************************************************************
 
	Copyright (C) 2007- Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	<math.h>
#include	"memory_debug.h"
#include	"utils.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"mx_format.h"
#include	"geo.h"


/*
([gmxImportDTED1 id="mtx-id" ch="utm-channel" level="level"]
	DTED1FilnameWithPath
	mtx-offset-x mtx-offset-y 
	)
id : integer : destination mtx file id
ch : integer : destination mtx data channel id
level : integer destination mtx layer level
DTED1FilenameWithPath : string : filename and pathname
mtx-offset-x : integer : (0 0) point address longitude (second)
mtx-offset-y : integer : (0 0) point address latitude (second)

*/


XL_SEXP * gb_gmxImportDTED1();

void
init_gmxImportDTED1(XLISP_ENV * env0,XLISP_ENV * env1)
{
	set_env(env1,l_string(std_cm,"gmxImportDTED1"),
		get_func_prim(gb_gmxImportDTED1,FO_APPLICATIVE,0,4,4));
}



XL_SEXP *
gb_gmxImportDTED1(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MX_ENTRY * mx_e;
L_CHAR * id;
int ch;
L_CHAR * _ch;
char * path;
int longitude,latitude;

XL_SEXP * data;
char * err_msg;
int pp;

short * result;
int west,north;
int er;
int line_ptr,line_offset,line_length;
short * ptr;
int nc;
int level;
L_CHAR * _level;

MX_CACHE_PARAM p;
INTEGER64 * target;
int	gn_tree_node;
int	gn_create;
int	gn_wait;

unsigned char * valid;
int i;


	path = 0;
	result = 0;
	err_msg = "id";
	id = get_sf_attribute(sf,l_string(std_cm,"id"));
	if ( id == 0 )
		goto inv_param;
	mx_e = search_mx_entry_by_id(atoi(n_string(std_cm,id)));
	if ( mx_e == 0 )
		goto inv_param;

	err_msg = "ch";
	_ch = get_sf_attribute(sf,l_string(std_cm,"ch"));
	if ( _ch == 0 )
		goto inv_param;
	ch = atoi(n_string(std_cm,_ch));
	
	err_msg = "level";
	_level = get_sf_attribute(sf,l_string(std_cm,"level"));
	if ( _level == 0 )
		level = 0;
	else 	level = atoi(n_string(std_cm,_level));
	

	data = get_el(s,1);
	switch ( get_type(data) ) {
	case XLT_STRING:
		path = ln_copy_str(std_cm,data->string.data);
		break;
	default:
		err_msg = "Filename with Path";
		goto type_missmatch;
	}

	data = get_el(s,2);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		longitude = data->integer.data;
		break;
	case XLT_FLOAT:
		longitude = data->floating.data;
		break;
	default:
		err_msg = "offset_y(Arg 2)";
		goto type_missmatch;
	}

	data = get_el(s,3);
	switch ( get_type(data) ) {
	case XLT_INTEGER:
		latitude = data->integer.data;
		break;
	case XLT_FLOAT:
		latitude = data->floating.data;
		break;
	default:
		err_msg = "reso_x(Arg 3)";
		goto type_missmatch;
	}

	pp = strlen(path);
	pp --;
	for ( ; pp >= 0 && path[pp] != '/' ; pp -- );
	if ( pp < 0 ) {
		err_msg = "invalid path name ";
		goto type_missmatch;
	}
	path[pp] = 0;
	pp ++;

	result = d_alloc(DTED1_BLOCK_SIZE*DTED1_BLOCK_SIZE*sizeof(short));
	er = load_dted1(
		result,
		&west,&north,
		0,
		path,&path[pp],DTED1_CMD_ROUND|DTED1_CMD_INTP);
	if ( er < 0 )
		goto cannot_open;
	
	north -= latitude;
	north /= 3;
	west -= longitude;
	west /= 3;
ss_printf("==4 %i %i %lli\n",latitude,north,mx_e->c.m->pixel_size_list[level][1]);
	if ( north >= mx_e->c.m->pixel_size_list[level][1] ) {
		line_ptr = (north - mx_e->c.m->pixel_size_list[level][1] + 1)
				* DTED1_BLOCK_SIZE;
		nc = DTED1_BLOCK_SIZE - 
			(north - mx_e->c.m->pixel_size_list[level][1] + 1);
ss_printf("==3\n");
		if ( nc <= 0 )
			goto end;
	}
	else {
		line_ptr = 0;
		nc = DTED1_BLOCK_SIZE;
	}
	if ( west < 0 ) {
		line_offset = - west;
ss_printf("==2\n");
		if ( line_offset >= DTED1_BLOCK_SIZE )
			goto end;
		west = 0;
		line_length = DTED1_BLOCK_SIZE - line_offset;
	}
	else {
		line_offset = 0;
		line_length = DTED1_BLOCK_SIZE;
	}
	if ( west + line_length > mx_e->c.m->pixel_size_list[level][0] ) {
		line_length = mx_e->c.m->pixel_size_list[level][0] - west;
	}
	if ( line_length == 0 )
		goto end;
ss_printf("==1\n");

	target = mxc_alloc(&mx_e->c,sizeof(INTEGER64)*3);
	target[0] = level;
	target[1] = west;
	target[2] = north;
	
	flush_mx_cache(&mx_e->c,0);

	gn_tree_node = mx_e->c.gn_tree_node;
	gn_create = mx_e->c.gn_create;
	gn_wait = mx_e->c.gn_wait;
	
	mx_e->c.gn_tree_node = GN_TREE;
	mx_e->c.gn_create = GN_LIST_CREATE;
	mx_e->c.gn_wait = GN_LIST_CREATE;


	set_matrix_env(mx_e->c.m,"create-node","enable");

	p = mx_e->p;
	p.dc = target;
	p.ofs = 0;
	p.data_ptrs[0] = 0;
	p.data_ptrs[1] = &ptr;
	p.data_ptrs[2] = 0;
	p.data_ptrs[3] = 0;
	p.vector_valid = valid = mxc_alloc(&mx_e->c,line_length);
	for ( i = 0 ; i < line_length ; i++ )
		valid[i] = 1;

	p.data_ix = mxc_alloc(&mx_e->c,sizeof(MX_CACHE_PARAM_IX)*mx_e->c.m->p.channel_nos);
	for ( i = 0 ; i < mx_e->c.ds_len ; i ++ ) {
		if ( mx_e->c.access_ch[i] == ch ) {
			p.data_ix[i].x = 0;
			p.data_ix[i].p = 1;
		}
		else {
			p.data_ix[i].x = MXC_INVALID;
			p.data_ix[i].p = 0;
		}
	}
	p.vector_len = line_length;
	
ss_printf("== %i %i %i %s\n",line_ptr,line_offset,line_length,pt_dc(mx_e->c.m,target,PTDC_NODE_ID));
	for ( ; 
			nc ; nc -- ) {
/*
		if ( north < 0 )
			break;
*/
//ss_printf("h=%i\n",nc);
		ptr = result+line_ptr+line_offset;

		er = write_mx_cache_vector(&p);
if ( er < 0 )
ss_printf("h=%i %i %i\n",nc,er,mx_cache_error);
		line_ptr += DTED1_BLOCK_SIZE;

		target[2] -= ((INTEGER64)1)<<
			(target[0]*mx_e->c.m->dim_divide[0]);
	}
	mx_e->c.gn_tree_node = gn_tree_node;
	mx_e->c.gn_create = gn_create;
	mx_e->c.gn_wait = gn_wait;

	mxc_free(&mx_e->c,target);
	mxc_free(&mx_e->c,valid);
	mxc_free(&mx_e->c,p.data_ix);

end:
	d_f_ree(result);
	if ( path )
		d_f_ree(path);
	flush_mx_cache(&mx_e->c,0);
	return 0;

type_missmatch:
	if ( path )
		d_f_ree(path);
	if ( result )
		d_f_ree(result);
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gmxImportDTED1"),
		List(n_get_string("type missmatch"),n_get_string(err_msg),-1));

cannot_open:
	if ( path )
		d_f_ree(path);
	if ( result )
		d_f_ree(result);
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_OPEN_FILE,
		l_string(std_cm,"gmxImportDTED1"),
		List(n_get_string("cannot open the file or convert the file "),
			get_integer(er,0),
			-1));

inv_param:
	if ( path )
		d_f_ree(path);
	if ( result )
		d_f_ree(result);
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gmxImportDTED1"),
		List(n_get_string("invalida parameter"),
			n_get_string(err_msg),
			-1));
/*
permission_error:
	if ( path )
		d_f_ree(path);
	if ( result )
		d_f_ree(result);
	flush_mx_cache(&mx_e->c,0);
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_PERMISSION_DENIED,
		l_string(std_cm,"gmxImportDTED1"),
		n_get_string("file path"));
*/
}

