/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"u_math.h"
#include	"gbview.h"
#include	"win_flame.h"
#include	"resource.h"

void
_change_table(GBVIEW_FLAME * gf,int geo_type)
{
WIN_FLAME * wf;
	for ( wf = gf->flame ; wf ; wf = wf->next )
		_change_win_flame(gf,wf,geo_type,0);
}

void
_calc_pitch(GBVIEW_FLAME * gf,int flag)
{

int geo_type;
WIN_FLAME_TABLE * tbl;
if ( _ch_locked(&gf->_wf_lock) == 0 )
er_panic("_calc_pitch");

	if ( gf->flame_base == 0 || gf->flame_base->draw == 0 )
		return;
	geo_type = (gf->flame_base->draw->c.geometory_type&GT_T_MASK)>>GT_T_SHIFT;
	gf->flame_base_geo_type = geo_type;
	tbl = wf_geo_type_list[geo_type][gf->flame_base->tbl->wf_type];
	(*tbl->f_calc_pitch)(gf,flag);
	_change_table(gf,geo_type);
}

void
calc_pitch(GBVIEW_FLAME * gf,int flag)
{
	wf_lock(gf);
	_calc_pitch(gf,flag);
	wf_unlock(gf);
}


void
center_check(GBVIEW_FLAME * gf)
{
	if ( gf->flame_base_center.x > 151 )
		er_panic("center");
	printf("CENTER %f\n",gf->flame_base_center.x);
}
