/**********************************************************************
 
	Copyright (C) 2003-2008 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"win_flame.h"

//int e2d_p_zoom_etc();

WIN_FLAME_TABLE e2d_gen = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_GEN,
	0,
	e2d_move_gen,
	0,
	0,
	0,
	0,
	0,
	e2d_zoom_gen,
	0,
	/*e2d_rotate_gen*/0,
	0,
	0,
	e2d_calc_pitch,
	0
};

WIN_FLAME_TABLE std_e2d = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_STD,
	e2d_new,
	e2d_move,
	e2d_exit,
	e2d_change,
	e2d_redraw,
	e2d_dirty,
	e2d_overlay,
	e2d_zoom,
	e2d_resize,
	e2d_rotate,
	0,
	e2d_setup_drawrect,
	e2d_calc_pitch,
	0
};


WIN_FLAME_TABLE e2d_small = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_SMALL,
	e2d_new,
	e2ds_move,
	e2d_exit,
	e2ds_change,
	e2ds_redraw,
	e2ds_dirty,
	e2ds_overlay,
	e2ds_zoom,
	e2ds_resize,
	e2ds_rotate,
	e2ds_get_weight,
	e2ds_setup_drawrect,
	e2d_calc_pitch,
	0
};


WIN_FLAME_TABLE e2d_plot = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_PLOT,
	e2d_new,
	e2d_p_move,
	e2d_p_exit,
	e2d_p_change,
	e2d_p_redraw,
	e2d_p_dirty,
	0,
	(f_zoom_type)e2d_p_zoom_etc,
	e2d_p_resize,
	(f_rotate_type)e2d_p_zoom_etc,
	0,
	e2d_setup_drawrect,
	e2d_calc_pitch,
	0
};


WIN_FLAME_TABLE globe_gen = {
	GT_T_GLOBE_SUR>>GT_T_SHIFT,
	WFT_GEN,
	0,
	globe_move_gen,
	0,
	0,
	0,
	0,
	0,
	e2d_zoom_gen,
	0,
	/*e2d_rotate*/0,
	0,
	e2d_setup_drawrect,
	globe_calc_pitch,
	0
};

WIN_FLAME_TABLE std_globe = {
	GT_T_GLOBE_SUR>>GT_T_SHIFT,
	WFT_STD,
	e2d_new,
	globe_move,
	e2d_exit,
	e2d_change,
	e2d_redraw,
	e2d_dirty,
	e2d_overlay,
	e2d_zoom,
	e2d_resize,
	e2d_rotate,
	0,
	e2d_setup_drawrect,
	globe_calc_pitch,
	0
};

WIN_FLAME_TABLE std_globe_small = {
	GT_T_GLOBE_SUR>>GT_T_SHIFT,
	WFT_SMALL,
	e2d_new,
	globe_small_move,
	e2d_exit,
	e2ds_change,
	e2ds_redraw,
	e2ds_dirty,
	e2ds_overlay,
	e2ds_zoom,
	e2ds_resize,
	e2ds_rotate,
	e2ds_get_weight,
	e2ds_setup_drawrect,
	globe_calc_pitch,
	0
};

WIN_FLAME_TABLE globe_plot = {
	GT_T_GLOBE_SUR>>GT_T_SHIFT,
	WFT_PLOT,
	e2d_new,
	globe_move_plot,
	e2d_p_exit,
	e2d_p_change,
	e2d_p_redraw,
	e2d_p_dirty,
	0,
	(f_zoom_type)e2d_p_zoom_etc,
	e2d_p_resize,
	(f_rotate_type)e2d_p_zoom_etc,
	0,
	e2d_setup_drawrect,
	globe_calc_pitch,
	0
};

WIN_FLAME_TABLE e1d_gen = {
	GT_T_1D>>GT_T_SHIFT,
	WFT_GEN,
	0,
	e1d_move_gen,
	0,
	0,
	0,
	0,
	0,
	e1d_zoom_gen,
	0,
	0,
	0,
	0,
	e1d_calc_pitch,
	e1d_wf_insert_action_gen,
};


WIN_FLAME_TABLE std_e1d = {
	GT_T_1D>>GT_T_SHIFT,
	WFT_STD,
	e2d_new,
	e1d_move,
	e2d_exit,
	e2d_change,
	e1d_redraw,
	e1d_dirty,
	e1d_overlay,
	e1d_zoom,
	e2d_resize,
	0,
	0,
	e1d_setup_drawrect,
	e1d_calc_pitch,
	e1d_wf_insert_action
};



WIN_FLAME_TABLE e1d_plot = {
	GT_T_1D>>GT_T_SHIFT,
	WFT_PLOT,
	e2d_new,
	e1d_p_move,
	e2d_p_exit,
	e2d_p_change,
	e1d_p_redraw,
	e2d_p_dirty,
	0,
	(f_zoom_type)e2d_p_zoom_etc,
	e2d_p_resize,
	(f_rotate_type)e2d_p_zoom_etc,
	0,
	e1d_setup_drawrect,
	e1d_calc_pitch,
	e1d_wf_insert_action_plot
};

WIN_FLAME_TABLE e1d_small = {
	GT_T_2D>>GT_T_SHIFT,
	WFT_SMALL,
	e2d_new,
	e1ds_move,
	e2d_exit,
	e2ds_change,
	e1ds_redraw,
	e2ds_dirty,
	e1d_overlay_small,
	e1ds_zoom,
	e2ds_resize,
	0,
	e1ds_get_weight,
	e2ds_setup_drawrect,
	e1d_calc_pitch,
	e1d_wf_insert_action_small
};


WIN_FLAME_TABLE * wf_geo_type_list[GT_T_MAX][WFT_MAX] = {
	{0,0,0,0},
	{		/* GT_T_2D */
		&e2d_gen,
		&std_e2d,
		&e2d_plot,
		&e2d_small
	},
	{		/* GT_T_GLOBE_SUR */
		&globe_gen,
		&std_globe,
		&globe_plot,
		&std_globe_small
	},
	{		/* GT_T_1D */
		&e1d_gen,
		&std_e1d,
		&e1d_plot,
		&e1d_small
	}
};


