/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___SEARCH_H___
#define ___SEARCH_H___

#include	"pdb.h"
#include	"gbs_trailer.h"

typedef struct p2d_s_pt_t_list {
	struct p2d_s_pt_t_list *	next;
	P2D_S_PT_TRAILER		d;
} P2D_S_PT_T_LIST;

typedef struct p2d_l_pt_t_list {
	struct p2d_l_pt_t_list *	next;
	P2D_L_PT_TRAILER		d;
} P2D_L_PT_T_LIST;


typedef struct p2d_t_list {
	struct {
		struct p2d_t_list *	next;
		int			length;
	}	h;
	union {
		P2D_S_TRAILER		s;
		P2D_L_TRAILER		l;
	}	d;
} P2D_T_LIST;


typedef struct p2d_col_t_list {
	struct p2d_col_t_list *	next;
	P2D_COL_TRAILER		c;
} P2D_COL_T_LIST;

typedef struct search_work {
	P2D_T_LIST *		t_list;
	P2D_COL_T_LIST *	color;
} SEARCH_WORK;

typedef struct condition {
	struct {
		GB_RECT_F 	r;
	} min;
	struct {
		GB_RECT_F	r;
	} max;
	int	lod;
	int	min_effect;
	int	min_equ;
	int	max_effect;
	int	max_equ;
	GB_RECT_F	r;
} CONDITION;

typedef struct request {
	CONDITION *	cond;
	short	flags;
#define RF_EMPTY	0x0001
#define RF_SHORT	0x0002
#define RF_HEADER	0x0004
#define RF_POLYGON	0x0008
#define RF_BINARY	0x0010
	int		code;
	GB_COLOR	line_color;
	GB_COLOR	padding_color;
	int		s_pnos;
	int		l_pnos;
 	int		type;
	P2D_S_PT_T_LIST * pt_s_trailer;
	P2D_L_PT_T_LIST * pt_l_trailer;
} REQUEST;


/*
typedef struct delay_pdbp_t {
	DELAY_FUNC		h;
	PDB *			p;
	struct delay_pdbp_t *	next;
} DELAY_PDBP_T;
*/

int	pdbp_file_header();
int	pdbp_2d_draw_header();
int	pdbp_tree_node();
int	pdbp_polygon2d();
int	pdbp_polygon2d_subname();
int	pdbp_information();
int	pdbp_poly_point();
int	pdbp_poly_end();

XL_SEXP *
search_pdbp_t(char * filename,GB_RECT_F * r,int min,
	XL_FILE * f,int line);

#endif


