/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___COSMOS_H___
#define ___COSMOS_H___

#include	"gbview.h"


#ifdef __cplusplus

#include	"v/v.h"


typedef struct cosmos_flame {
	int		seq;
	int		seq_lock;

	VWindow *	window;

	int		redraw_flag;
	int		im_out_off;

	VDraw *		im;
	VPushButton *	zoom_in;
	VPushButton *	zoom_out;
	VPushButton *	web_page;
	VRadioButton *	grab_button;
	VRadioButton *	rotate_button;
	VPushButton *	exit_button;

	int		select_mode;

	int		mode;
/*
#define GBM_IDLE		0
#define GBM_PRESS_IMAGE		1
#define GBM_PRESS_ZOOM_IN	2
#define GBM_PRESS_ZOOM_OUT	3
#define GBM_PRESS_WEB_PAGE	4
#define GBM_PRESS_MODE_BTN	5
#define GBM_PRESS_EXIT_BTN	6
*/
	int		press_x;
	int		press_y;
	REAL1		press_zoom;
	int		press_time;

	VImage *	ss;
	PTR_INDEX	ix;
	void *		last_shot;
	void *		start_shot;
	MOVE_SET *	ms;

	I_POINT		select_st;
	I_POINT		select_end;
	int		select_flag;

} COSMOS_FLAME;


#endif

#define CALL_STS_CACHE_NORMAL 1
#define CALL_STS_CACHE_REFRESH 2


void tate_ditect(char * msg,unsigned long * buf,int st,int pitch,int lines);
void tick_xli();
void init_interface();
void checkin_seq(int seq);
void checkout_seq(int seq);
void countup_seq(int seq);
void _free_index();
void _set_index(int type,int w,int h);
int grab_index_func_2d();
int grab_index_func_globe(GBVIEW_STATUS * sts);

void ipc_init(int argc,char ** argv);
void write_task();
void launch_gbview();
void ipc_system(int argc,char ** argv);

void event_task();
void *call_window_function(char * win);

#endif
