/**********************************************************************
 
	Copyright (C) 2003-2004
	Hirohisa MORI <joshua@nichibun.ac.jp>
	Tomoki SEKIYAMA <sekiyama@yahoo.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___V_FOCUS_VIEW_H___
#define ___V_FOCUS_VIEW_H___

#include "v/VObject.h"
#include "v/VEditable.h"

class VFocusView : public VObject, public VEditable
{
  public:
	enum { object_type = VO_FCSV };
	virtual unsigned	get_type() const { return object_type; }
	virtual unsigned	max_children() const { return MAX_CHILDREN_NO_LIMIT; }
	
	static VFocusView*	create(const VObjectStatus *s, int flags, VExError *err=0) {
			return create(s, flags, 0, err);
	}
	static VFocusView*	create(const VObjectStatus *s, int flags, void *arg, VExError *err) {
		return static_cast<VFocusView*>(
			create_tmp(internal_new, object_type, s, flags, err));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	child_status_changed(VObject *child, VInfo* info);

	virtual void	redraw(VRect* rect = 0) const;
	
	virtual void	focus();
	virtual void	check_menu_status()
	{
		if (command_status_handler)
			vq_insert_callback_machine(this,command_status_handler,command_status_eh_arg,0,0,0,0);
		else
			set_editable_flags(0);
	}
	virtual void	set_editable_flags(int flags)
	{
		int d = editable_flags != flags ? 1 : 0;
		editable_flags = flags;
		set_menu_dirty(d);
	}
	void			set_command_status_handler(V_CALLBACK_T handler, void *user_arg)
	{
		command_status_handler = handler;
		command_status_eh_arg = user_arg;
	}
	virtual bool	command_status(int type) const
	{
		if ( (type - VMT_EDIT_START) & editable_flags )
			return true;
		else	return false;
	}

	virtual bool	obey_command(int type)
	{
		if ( type >= VMT_EDIT_START && type <= VMT_EDIT_END ) {
			vq_insert_callback_machine(this, call_obey_command_handler,
								obey_command_eh_arg, &type, sizeof(type),0,0);
			return true;
		}
		return false;
	}
	void			set_obey_command_handler(V_CALLBACK_T handler, void *user_arg)
	{
		obey_command_handler = handler;
		obey_command_eh_arg = user_arg;
	}
	static V_CALLBACK_D(call_obey_command_handler);

	int				get_menu_dirty() { return menu_dirty; }
	void			set_menu_dirty(int d);

  protected:
	virtual ~VFocusView();
	
	virtual VExError	create_do(const VObjectStatus *, int flags,
					VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	virtual VExError add_child_do(VObject*);
	virtual void	remove_child_do(VObject* child);

	V_CALLBACK_T	command_status_handler;
	void *			command_status_eh_arg;

	V_CALLBACK_T	obey_command_handler;
	void *			obey_command_eh_arg;

	int				editable_flags;
	int				menu_dirty;

  private:
	static VObject *internal_new(){
		return new VFocusView();
	}
};


#endif
