/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___V_GB_INDICATE_H___
#define ___V_GB_INDICATE_H___


extern "C" {
#include	"radar.h"
}

#include	"v/VMacro.h"
#include	"v/VexDraw.h"
#include	"v/VStaticText.h"
#include	"v/VAlignView.h"

#define IND_ARY_LEN		R_IND_ARY_LEN
#define IND_ARY_MASK1		((1<<IND_ARY_LEN)-1)
#define IND_ARY_MASK2		(IND_ARY_MASK1<<IND_ARY_LEN)


typedef struct _VgbIndicateImage {
	VImage *		img;
	L_CHAR *		name;
	int			levels;
	VRect			elr;
	int			pitch;
} VgbIndicateImage;


typedef struct _VgbIndicateStatus {
	VgbIndicateImage	ary[IND_ARY_LEN];
} VgbIndicateStatus;


typedef union _VgbIndicateMeter {
	int			ary[IND_ARY_LEN];
} VgbIndicateMeter;


class VgbIndicate : public VMacro
{
  public:
	enum { object_type = VO_GIND };

	virtual unsigned	get_type() const { return object_type; }

	static VgbIndicate*
	create(const VObjectStatus *s, int flags, VExError* err=0) {
		return create(s, flags, 0, err);
	}
	static VgbIndicate*
	create(const VObjectStatus *s, int flags, void * arg, VExError* err) {
		return static_cast<VgbIndicate*>(
			create_tmp(internal_new, object_type, s, flags, err,arg));
	}

	virtual VExError	get_status(VObjectStatus *, int flags) const;
	virtual VExError	set_status(const VObjectStatus *, int flags);
	
	virtual void	redraw(VRect* rect = 0) const;

	virtual VExError get_indicate_status(
				VgbIndicateStatus *,
				int flags) const;
	virtual VExError set_indicate_status(
				const VgbIndicateStatus *,
				int flags);

	virtual VExError get_indicate_meter(
				VgbIndicateMeter *,
				int flags) const;
	virtual VExError set_indicate_meter(
				const VgbIndicateMeter *,
				int flags);
  protected:

  	virtual ~VgbIndicate();

	virtual VExError	create_do(const VObjectStatus* s, int flags,VObject * nmp, void * arg);
	virtual void	destroy_do(VObject*);
	virtual void	destroy_do_out_of_lock(VObject*);

  private:
	static VObject *internal_new(){
	VgbIndicate * ret;
		ret = new VgbIndicate();
		return ret;
	}
	VgbIndicateMeter	meter;
	VgbIndicateMeter	limit;
	VexDraw *		d_obj[IND_ARY_LEN];
	VStaticText *		t_obj[IND_ARY_LEN];
	VHAlignView *		align;
};




#endif
