/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"pdb.h"
#include	"utils.h"
#include	"fa.h"
#include	"machine/err.h"	
void
close_pdb(PDB * p)
{
int er;

retry:
	er = u_close(p->fid);
	if ( er < 0 && errno == EINTR )
		goto retry;
	close_file(p->cache);
	free_request(p->next_request);
	free_request(p->request);
	d_f_ree(p);
}
