/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef GM_CONVERT_ENV_H___
#define GM_CONVERT_ENV_H___

#include "vpf_table.h"
#include "gm_tileref_aft.h"
#include "gm_svg_color.h"

typedef struct{
	char library_directory[MAX_PATH+1];
	VPF_TABLE *coverage_attribute_table;
	VPF_TABLE *data_quality_table;
	VPF_TABLE *geographic_reference_table;
	VPF_TABLE *tileref_table;
	GM_SVG_COLOR_TABLE *color_table;
}GM_CONVERT_ENV;

GM_CONVERT_ENV *gm_convert_env_new(const char *library_directory, const char *configure_file);
void gm_convert_env_delete(GM_CONVERT_ENV *env);
GM_TILEREF_AFT_RECORD *gm_env_get_tile(GM_CONVERT_ENV *env, LONG tileid);

#endif

