/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include "kibandata.h"
#include "arc_data.h"
#include "poly_data.h"
#include "attr_data.h"

typedef struct map_node{
	int nCol;
	int nRow;
	ARC_DATA *pArcData;
	POLY_DATA *pPolyData;
	ATTR_DATA *pAttrData;
	char szMapName[8];
} MAP_NODE;

typedef struct map_matrix{
	int nColSize;
	int nRowSize;
	int DataType;
	MAP_NODE **maps;
} MAP_MATRIX;

typedef struct bunrui_file_name_set{
	char szFileNames[3][MAX_PATH];
	int nDataTypes[3];
} BUNRUI_FILE_NAME_SET;


#define FJA_TO_PREV 1
#define FJA_TO_NEXT 2
typedef struct arc_id_record_ptr_list{
	struct arc_id_record_ptr_list *pNext;
	struct arc_id_record_ptr_list *pPrev;
	ARC_ID_RECORD *pRecord;
	MAP_NODE *pMap;
}ARC_ID_RECORD_PTR_LIST;


/* ޥȥꥯ */
MAP_MATRIX *MMCreate(const char *szZuyouFileName, int DataFileType, KIBAN2SVG_PROCESSING_INFO_DATA *pInfo);
/* ޥȥꥯ˴ޤޤݥꥴϢ뤷֤ */
int JoinPolyInMatrix(MAP_MATRIX *pMatrix, POLY_DATA **ppPolyJoined, ATTR_DATA **ppAttrJoined);

/* ޥȥꥯ˴ޤޤ륢򤹤٤Ʒ礷֤ */
int JoinArcsInMatrix(MAP_MATRIX *pMatrix, ARC_DATA **ppArcJoined, ATTR_DATA **ppAttrJoined);


/*
ꤷդˡդ˴ޤޤ륢٤ƤηǤ륢򸡺ơǡpArcJoined˳Ǽ롣*/
int JoinArcsInMap(ARC_DATA *pArcJoined, ATTR_DATA *pAttrJoined, MAP_MATRIX *pMatrix, int nCol, int nRow, int *nNewID, VC_HASH_TABLE *pIDConv);

/* ޥȥꥯ˴ޤޤ礵륢ΥꥹȤ֤ */
void FindJoinArcsInMatrix(MAP_MATRIX *pMatrix, V_LIST **JoinArcsList);
/* ꤷդˡդ˴ޤޤ륢٤ƤηǤ륢򸡺ơ̤JoinArcsList˳Ǽ */
void FindJoinArcsInMap(MAP_MATRIX *pMatrix, int nCol, int nRow, V_LIST **JoinArcsList);
/* ꤷˡǤ륢򼡡ȸ̤pJoinArcList˳Ǽ */
void FindJoinArcs(ARC_ID_RECORD_PTR_LIST *pJoinArcList,  
				  GB_POINT *ptFrom, GB_POINT *ptFrom2, char *szCode, MAP_MATRIX *pMapMatrix, int nCol, int nRow, int Direction, int nRefferCol, int nRefferRow);

/* ޥȥꥯ˴ޤޤ뤹٤ƤΥΣɣĤդʤΤѴ */
void UniqeArcIDInMatrix(MAP_MATRIX *pMatrix);
/* ƬʸszFilterΣɣĤä쥳ɤ˺ե饰ΩƤ */
void RemoveArcFromMatrixById(MAP_MATRIX *pMatrix, char *szFilter);
/* ޥȥꥯ˴ޤޤ륢򤹤٤ƣӣ֣Ǥ˽ */
void ArcData2SVGInMatrix(FILE *fp, MAP_MATRIX *pMatrix, char *szColor);
/* ޥȥꥯ˴ޤޤ뤹٤Ƥ°أ̤ͣ˽ */
void AttrData2XMLInMatrix(FILE *fp, MAP_MATRIX *pMatrix);
int ReadMapsFromMapName(MAP_MATRIX *pMatrix, 
					  int nOrignCol,
					  int nOriginRow,
					  const char *szDataRootPath,
					  const char *szMapName,
					  int DataFileType);
int SetMapMatrixCount(MAP_MATRIX *pMatrix, int nColSize, int nRowSize, int nColOffset, int nRowOffset);
void free_map_matrix(MAP_MATRIX *pMatrix);
typedef struct join_arc_candidate{
	ARC_ID_RECORD *pRecord;
	int HitPos;
#define JAC_HIT_BEGIN 1
#define JAC_HIT_END   2
}JOIN_ARC_CANDIDATE;

