/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"
#include	"memory_routine.h"


XL_SEXP *
xl_mxAdd(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxAdd(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxAdd"),
		get_func_prim(xl_mxAdd,FO_APPLICATIVE,0,3,3));
}


XL_SEXP *
xl_mxAdd(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
L_CHAR * opt;
int _opt;
MATRIX_TOKEN * t;
INTEGER64 * dim_code1, * dim_code2;
void * d1, * d2, * dest;
MATRIX_DH_SET dh1,dh2;
MATRIX_DATA_HEADER * dest_h;
MATRIX_DATA_TYPE * tp;
int _ret;
XL_SEXP * ret;
	dim_code1 = dim_code2 = 0;
	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	opt = get_sf_attribute(sf,l_string(std_cm,"option"));
	if ( opt == 0 )
		_opt = 0;
	else if ( l_strcmp(opt,l_string(std_cm,"TRUNC")) == 0 )
		_opt = OPT_TRUNC;
	else if ( l_strcmp(opt,l_string(std_cm,"CURVE")) == 0 )
		_opt = OPT_CURVE;
	else	goto inv_param;

	dim_code1 = get_dim_code_from_sexp(t->process_node->matrix,get_el(get_el(s,1),1));
	if ( dim_code1 == 0 )
		goto type_missmatch;
	d1 = get_vdata_from_sexp(get_el(get_el(s,1),2));
	if ( d1 == 0 )
		goto type_missmatch;
	get_matrix_dh_set(&dh1,d1);	

	dim_code2 = get_dim_code_from_sexp(t->process_node->matrix,get_el(get_el(s,2),1));
	if ( dim_code2 == 0 )
		goto type_missmatch;
	d2 = get_vdata_from_sexp(get_el(get_el(s,2),2));
	if ( d2 == 0 )
		goto type_missmatch;
	get_matrix_dh_set(&dh2,d2);	

	if ( dh1.hd->type != dh2.hd->type )
		goto type_missmatch;
	tp = get_matrix_data_type(dh1.hd->type);
	dest = mmalloc(dh2.hd->offset + dh2.total_element *
			(*tp->parent->get_size)(tp,0),gc_text);
	dest_h = (MATRIX_DATA_HEADER*)dest;
	*dest_h = *dh2.hd;
	_ret = (*tp->v_add)(tp,t->process_node->matrix,
			dim_code2,dim_code1[0] - dim_code2[0],&_opt,dest,d1,d2);
	if ( _ret < 0 )
		goto matrix_err;

	ret = List(
		n_get_symbol("data"),
		get_sexp_from_dim_code(t->process_node->matrix,dim_code2),
		get_ptr(dest,gc_text),
		-1);
	goto end;

type_missmatch:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxAdd"),
		0);
	goto end;
inv_param:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxAdd"),
		n_get_string("invalid parameter in mxAdd"));
	goto end;
matrix_err:
	ret = get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxAdd"),
		n_get_string("invalid matrix loading"));
end:
	if ( dim_code1 )
		d_f_ree(dim_code1);
	if ( dim_code2 )
		d_f_ree(dim_code2);
	return ret;
}





