/**********************************************************************
 
	Copyright (C) 2005- Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"machine/include.h"
#include	"memory_debug.h"
#include	"pri_level.h"
#include	"lock_level.h"
#include	"utils.h"
#include	"task.h"
#include	"matrix.h"
#include	"xl.h"
#include	"xlerror.h"


XL_SEXP *
xl_mxSet(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf);

void
init_mxSet(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"mxSet"),
		get_func_prim(xl_mxSet,FO_APPLICATIVE,0,3,3));
}


XL_SEXP *
xl_mxSet(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
int _ch;
XL_SEXP * ch;
int ret;
XL_SEXP * er;
XL_SEXP * dc;
MATRIX_TOKEN * t;
L_CHAR * listed_dim_code;
INTEGER64 * dim_code1;
int err;
char * err_msg;
MATRIX_NODE * n;
	er = 0;
	t = get_env_work(env);
	if ( t == 0 )
		return 0;
	ch = get_el(s,1);
	if ( get_type(ch) != XLT_INTEGER )
		goto type_missmatch;
	_ch = ch->integer.data;

	listed_dim_code = get_sf_attribute(sf,l_string(std_cm,"listed-dim-code"));
	if ( listed_dim_code == 0 || l_strcmp(listed_dim_code,l_string(std_cm,"off")) == 0 ) {
		ret = set_channel_sexp(t->process_node,_ch,get_el(get_el(s,2),2));
		er = s;
		if ( ret < 0 )
			goto inv_param;
	}
	else if ( l_strcmp(listed_dim_code,l_string(std_cm,"on")) == 0 ) {
		dc = get_el(s,2);
		dim_code1 = get_dim_code_from_sexp(t->process_node->matrix,get_el(dc,1));


		err = 0;
		n = get_matrix_node(&err,t->process_node->matrix,dim_code1,
				GN_ERROR_NORETRY,t,0);
		er = List(
			get_integer(err,0),
			get_sexp_from_dim_code(t->process_node->matrix,dim_code1),
			-1);
		d_f_ree(dim_code1);
		if ( err == ME_ERR_NODE || n == 0 ) {
			err_msg = "children loading(2)";
			goto no_obj;
		}
		if ( err != 0 ) {
			if ( err == ME_MATRIX_ERR )
				goto matrix_err;
			return matrix_error("mxSet",
				s,AME_TRAP,er);
		}
		if ( n->channel == 0 ) {
			err_msg = "children loading(3)";
			goto no_obj;
		}
		ret = set_channel_sexp(n,_ch,get_el(dc,2));
		er = s;
		if ( ret < 0 )
			goto inv_param;
	}
	else {
		er = n_get_string("listed-dim-code");
		ret = 0;
		goto inv_param;
	}

	return get_integer(ret,0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"mxSet"),
		0);
inv_param:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"mxSet"),
		List(n_get_string("invalid parameter in mxSet CH = "),
			get_integer(_ch,0),
			n_get_string("inner information = "),
			get_integer(ret,0),
			er,
			-1));
no_obj:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxSet"),
		List(n_get_string("invalid object in channel of NODE"),
			n_get_string(err_msg),
			er,-1));
matrix_err:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_OBJECT,
		l_string(std_cm,"mxSet"),
		n_get_string("invalid matrix loading"));
}





