/**********************************************************************
 
	Copyright (C) 2006 Hirohisa MORI <joshua@globalbase.org>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"memory_debug.h"
#include	"mx_blk_primitive.h"
#include	"xlerror.h"


typedef struct pr_struct_block {
	MX_STRUCT_BLOCK			h;
	MATRIX_ALLOC_BLOCK_PARAM	p;
} PR_STRUCT_BLOCK;




MX_STRUCT_BLOCK * pr_new_sb(MX_SB_NEW*,void*);
MX_STRUCT_BLOCK * pr_copy_sb(MX_STRUCT_BLOCK*);
int  pr_block2struct(MX_STRUCT_BLOCK*,MATRIX_ALLOC_BLOCK_PARAM * b);
MATRIX_ALLOC_BLOCK_PARAM * pr_struct2block(MX_STRUCT_BLOCK * blk);
void pr_free_sb(MX_STRUCT_BLOCK * blk);
int pr_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param);
MX_STRUCT_BLOCK * pr_copy_sb(MX_STRUCT_BLOCK * );

MX_STRUCT_BLOCK_TBL blk_primitive_tbl = {
	pr_new_sb,
	pr_free_sb,
	pr_copy_sb,
	pr_block2struct,
	pr_struct2block,
	pr_operation
};

MX_STRUCT_BLOCK * pr_new_sb(MX_SB_NEW* n,void* param)
{
PR_NEW * np;
PR_STRUCT_BLOCK * b;
MX_SB_NEW nn;
	nn = *n;
	if ( nn.m ) {
		if ( nn.n ) {
			if ( nn.n->matrix != nn.m )
				return 0;
		}
	}
	else {
		if ( nn.n ) {
			nn.m = nn.n->matrix;
		}
	}
	np = (PR_NEW*)param;
	b = d_alloc(sizeof(*b));
	b->h.tbl = &blk_primitive_tbl;
	b->h.n = nn;
	b->p = *np;
	b->p.block = d_alloc(b->p.size);
	memcpy(b->p.block,np->block,b->p.size);
	return (MX_STRUCT_BLOCK*)b;
}


MX_STRUCT_BLOCK * pr_copy_sb(MX_STRUCT_BLOCK* b)
{
MX_STRUCT_BLOCK * ret;
PR_STRUCT_BLOCK * p;
	p = (PR_STRUCT_BLOCK*)b;
	ret = pr_new_sb(&p->h.n,&p->p);
	return ret;
}


int  pr_block2struct(MX_STRUCT_BLOCK* b,MATRIX_ALLOC_BLOCK_PARAM * p)
{
PR_STRUCT_BLOCK * ib;
	ib = (PR_STRUCT_BLOCK*)b;
	d_f_ree(ib->p.block);
	ib->p = *p;
	ib->p.block = d_alloc(ib->p.size);
	memcpy(ib->p.block,p->block,p->size);
	return 0;
}


MATRIX_ALLOC_BLOCK_PARAM * pr_struct2block(MX_STRUCT_BLOCK * blk)
{
MATRIX_ALLOC_BLOCK_PARAM * ret;
PR_STRUCT_BLOCK * ib;
	ib = (PR_STRUCT_BLOCK*)blk;
	ret = d_alloc(sizeof(*ret));
	memset(ret,0,sizeof(*ret));
	ret->size = ib->p.size;
	ret->block = d_alloc(ib->p.size);
	memcpy(ret->block,ib->p.block,ret->size);
	return ret;
}


void pr_free_sb(MX_STRUCT_BLOCK * blk)
{
PR_STRUCT_BLOCK * ib;
	ib = (PR_STRUCT_BLOCK*)blk;
	d_f_ree(ib->p.block);
	d_f_ree(ib);
}


int pr_operation(int cmd,MX_STRUCT_BLOCK * blk,void * param)
{
	return -1;
}






XL_SEXP *
xl_sbPrimitive(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV * a,XL_SYM_FIELD * sf)
{
MATRIX_TOKEN * t;
MX_SB_NEW n;
MX_STRUCT_BLOCK * b;
XL_SEXP * ch;
char * e_param;
	ch = eval(env,n_get_symbol("___channel"));
	switch ( get_type(ch) )  {
	case XLT_INTEGER:
		n.channel = ch->integer.data;
		break;
	case XLT_ERROR:
		return ch;
	default:
		e_param = "___channel";
		goto type_missmatch;
	}
	t = get_env_work(env);
	n.n = t->process_node;
	n.m = n.n->matrix;
	b = pr_new_sb(&n,0);
	return get_ptr(b,0);
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"GetHTMLQuery"),
		List(n_get_string(
			"type missmatch"),
			n_get_string(e_param),
			-1));
}

void
init_sbPrimitive(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"sbPrimitive"),
		get_func_prim(xl_sbPrimitive,FO_APPLICATIVE,0,1,1));
}


