/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<fcntl.h>
#include	<stdlib.h>
#include	"stream.h"
#include	"xl2pdb_p.h"
#include	"avt.h"
#include "svg2gb.h"

extern PDB_POLYGON2D * pdb_p_list;
extern CODE_INDEX *code_index;
extern AVT_NODE * pdb_same_name_avt;
extern CODE_METHOD * data_encoding_cm;
char info_file[INFO_FILENAME_SIZE];

STREAM *
open_info_file(int argc,char ** argv)
{
int i;
STREAM *fd;
	for ( i = 0 ; i < argc ; i ++ )
		if ( strcmp(argv[i],"/") == 0 )
			break;
	if ( i == argc )
		fd = 0;
	else {
		i ++;
		if ( i == argc )
			fd = 0;
	 	else {
			strcpy(info_file,argv[i]);
			for ( i = strlen(info_file)-1 ; i >= 0 ; i -- ) {
				if ( info_file[i] == '.' )
					break;
				if ( info_file[i] == '/' )
					break;
			}
			if ( i <= 0 || info_file[i] != '.' )
				i = strlen(info_file);
			strcpy(&info_file[i],".inf");
			fd = s_open_file(info_file,
				O_RDWR|O_CREAT|O_TRUNC,0644);
			if ( fd < 0 ) {
				fprintf(stderr,"cannot open the file\n");
				perror(info_file);
				exit(1);
			}
		}
	}
	return fd;
}

int
info_func(AVT_NODE * a,STREAM ** fd)
{
PDB_POLYGON2D * p, * pp;
XL_SEXP * sym;
char buf[32];
unsigned int code;
GB_RECT_F minrect;
XL_SEXP * target;
extern STREAM * info_tmp;
XL_SEXP * info_s;

	pp = p = a->data;

	minrect.tl.x = minrect.tl.y = 0;
	minrect.br.x = minrect.br.y = -1;
	for ( p = pp ; p ; p = p->samename )
		add_rect_f(&minrect,&p->minrect);
	code = pp->code/NO_PITCH;

	code_index[code].minrect = minrect;
	code_index[code].fofs = s_seek_file(*fd,0,SEEK_CUR);
	sprintf(buf,"%i",code*NO_PITCH);
	for ( p = pp ; p ; p = p->samename ) {
		if ( p->info_ofs && info_tmp ) {
			gc_push(0,0,"info_func");
			s_seek_file(info_tmp,p->info_ofs,SEEK_SET);
			info_s = init_parse(info_tmp,
					l_string(std_cm,"info.tmp"),
					l_string(std_cm,"file"));
			if ( info_s->h.file )
				info_s->h.file->flags |= XLF_DONT_CLOSE;
			target = car(info_s);
			sym = car(target);
			set_attribute(sym,
				l_string(std_cm,"code"),
				l_string(std_cm,buf));
			print_sexp(*fd,target,PF_LISP);
			s_printf(*fd,"\n");
			gc_pop(0,0);
			return 0;
		}
		else if ( p->info ) {
			gc_push(0,0,"info_func");
			sym = car(p->info);
			set_attribute(sym,
				l_string(std_cm,"code"),
				l_string(std_cm,buf));
			print_sexp(*fd,p->info,PF_LISP);
			s_printf(*fd,"\n");
			gc_pop(0,0);
			return 0;
		}
	}
	s_printf(*fd,
		"([information code=\"%i\" name=\"%s\" scheme=\"null\"])\n",
		code*NO_PITCH,
		n_string(std_cm,pp->name),
		n_string(std_cm,pp->subname));

	return 0;
}

/* output_info(int argc,char ** argv) */
void
output_info(SVG2GB_OUTPUTPP_INFO *o)
{
STREAM * fd;
char * filename;
int p;
PDB_POLYGON2D * pp;
void gc_tick();

	strcpy(info_file,o->filename_inf);

	filename = malloc(
		strlen(o->filename_pp)
		+strlen(o->filename_inf)+10);
	strcpy(filename,o->filename_pp);
	p = strlen(filename)-1;
	for ( ; p >= 0 && filename[p] != '/' ; p -- );
	p ++;
	strcpy(&filename[p],o->filename_inf);

	fd = s_open_file(filename,
				O_RDWR|O_CREAT|O_TRUNC,0644);
	if ( data_encoding_cm == 0 )
		er_panic("output_info");
	s_set_cm(fd,data_encoding_cm);
	free(filename);
	if ( fd < 0 ) {
		fprintf(stderr,"cannot open the file\n");
		perror(info_file);
		exit(1);
	}
	avt_trace_from_small(pdb_same_name_avt,info_func,&fd);
	s_printf(fd,"(end-of-information-file)\n");
	s_close(fd);

	for ( pp = pdb_p_list ; pp ; pp = pp->next )
		pp->info = 0;
	del_tick(gc_tick);
	gc_tick();
}
