/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"task.h"
#include	"memory_debug.h"
#include	"utils.h"
#include	"lock_level.h"
#include	"pri_level.h"



void tick_thread();
void tick_thread_2();
void new_timeout_func_3(int key);
void new_timeout_func_2(int key);


typedef struct tick_func {
	struct tick_func *	next;
	void			(*func)(int);
	int			data;
	int			interval;
} TICK_FUNC;

typedef struct tick_wheel {
	struct tick_wheel *	next;
	TICK_FUNC *		list;
	unsigned int		invoke;
} TICK_WHEEL;

void insert_tick(TICK_FUNC * tl,unsigned int time);
void insert_immidiate_tick(TICK_FUNC * tl);

TICK_WHEEL * wheel;
SEM tick_lock;
TICK_FUNC * target_tick;

TICK_FUNC * immidiate_tick;
TICK_FUNC * immidiate_tick_tail;
int tick_start_lock_flag;

void
init_tick()
{

	tick_lock = new_lock(LL_TICK);
	create_task((void(*)(TKEY))tick_thread,0,PRI_TICK);
	create_task((void(*)(TKEY))tick_thread_2,0,PRI_TICK_STRONG);
}

void
insert_immidiate_tick(TICK_FUNC * tl)
{
	lock_task(tick_lock);
	tl->next = 0;
	if ( immidiate_tick ) {
		immidiate_tick_tail->next = tl;
		immidiate_tick_tail = tl;
	}
	else	immidiate_tick = immidiate_tick_tail = tl;
	wakeup_task((int)&immidiate_tick);
	unlock_task(tick_lock,"insert_immidiate_tick");
}


void
insert_tick(TICK_FUNC * tl,unsigned int time)
{
TICK_WHEEL * w, ** wp;
	tl->next = 0;
	lock_task(tick_lock);
	for ( wp = &wheel ; *wp ; wp = &(*wp)->next ) {
		w = *wp;
		if ( w->invoke > time ) {
			break;
		}
		else if ( w->invoke == time ) {
			tl->next = w->list;
			w->list = tl;
			goto end;
		}
	}
	w = d_alloc(sizeof(*w));
	w->invoke = time;
	w->list = tl;
	w->next = *wp;
	*wp = w;
end:
	unlock_task(tick_lock,"new_tick(1)");
}

void
new_tick(void (*func)(int),int interval,int data)
{
TICK_FUNC * tl;
int _interval;
	tl = d_alloc(sizeof(*tl));
	tl->interval = interval;
	tl->func = func;
	tl->data = data;
	tl->next = 0;
	if ( interval < 0 )
		_interval = -interval;
	else	_interval = interval;
	if ( interval == 0 )
		insert_immidiate_tick(tl);
	else	insert_tick(tl,get_xltime() + _interval);
}

void
change_tick(int interval)
{
	if ( target_tick == 0 )
		return;
	target_tick->interval = interval;
}

void
del_tick(void (*func)(int))
{
TICK_WHEEL * w, ** wp;
TICK_FUNC * tl, ** tlp;
	lock_task(tick_lock);
	for ( wp = &wheel ; *wp ; ) {
		w = *wp;
		for ( tlp = &w->list ; *tlp ; ) {
			tl = *tlp;
			if ( tl->func != func ) {
				tlp = &tl->next;
				continue;
			}
			*tlp = tl->next;
			d_f_ree(tl);
		}
		if ( w->list )
			wp = &w->next;
		else {
			*wp = w->next;
			d_f_ree(w);
		}
	}
	unlock_task(tick_lock,"del_tick");
}

void
del_tick_with_data(void (*func)(int),int data)
{
TICK_WHEEL * w, ** wp;
TICK_FUNC * tl, ** tlp;
	lock_task(tick_lock);
	for ( wp = &wheel ; *wp ; ) {
		w = *wp;
		for ( tlp = &w->list ; *tlp ; ) {
			tl = *tlp;
			if ( tl->func != func || tl->data != data ) {
				tlp = &tl->next;
				continue;
			}
			*tlp = tl->next;
			d_f_ree(tl);
		}
		if ( w->list )
			wp = &w->next;
		else {
			*wp = w->next;
			d_f_ree(w);
		}
	}
	unlock_task(tick_lock,"del_tick");
}

void
tick_thread()
{
int time;
TICK_WHEEL * w;
TICK_FUNC * tf1, * tf2;

	sleep_sec(5);
	for ( ; tick_start_lock_flag ; ) {
		sleep_sec(1);
	}
	for ( ; ; ) {
		sleep_sec(1);
	more:
		time = get_xltime();
		lock_task(tick_lock);
		if ( wheel == 0 )
			goto next;
		if ( wheel->invoke > time )
			goto next;
		w = wheel;
		wheel = w->next;
		unlock_task(tick_lock,"tick_thread");

		for ( tf1 = w->list ; tf1 ; ) {
			tf2 = tf1->next;
			target_tick = tf1;
			(*tf1->func)(tf1->data);
			target_tick = 0;
			if ( tf1->interval <= 0 )
				d_f_ree(tf1);
			else {
				insert_tick(tf1,get_xltime() + tf1->interval);
			}
			tf1 = tf2;
		}
		d_f_ree(w);
		goto more;
	next:
		unlock_task(tick_lock,"tick_thread");
	}
}

void
tick_thread_2()
{
TICK_FUNC * f, * f2;
	for ( ; ; ) {
		lock_task(tick_lock);
		for ( ; immidiate_tick == 0  ; ) {
			sleep_task((int)&immidiate_tick,tick_lock);
			lock_task(tick_lock);
		}
		f = immidiate_tick;
		immidiate_tick = 0;
		immidiate_tick_tail = 0;
		unlock_task(tick_lock,"tick_thread_2");
		for ( ; f ; )  {
			f2 = f->next;
			(*f->func)(f->data);
			d_f_ree(f);
			f = f2;
		}
	}
}


void
new_timeout_func_3(int key)
{
	wakeup_task(key);
}

void
new_timeout_func_2(int key)
{
	wakeup_task(key);
	new_tick(new_timeout_func_3,-2,key);
}


void
new_timeout_func(int key)
{
	wakeup_task(key);
	new_tick(new_timeout_func_2,-2,key);
}


void
new_timeout(int key,int interval)
{
	if ( interval < 0 )
		new_tick(new_timeout_func,interval,key);
	else	new_tick(new_timeout_func,-interval,key);
}

void
del_timeout(int key)
{
	del_tick_with_data(new_timeout_func,key);
	del_tick_with_data(new_timeout_func_2,key);
	del_tick_with_data(new_timeout_func_3,key);
}


void tick_start_lock()
{
	tick_start_lock_flag = 1;
}

void tick_start_unlock()
{
	tick_start_lock_flag = 0;
}


